/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.Key;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class DisplayList
extends Canvas {
    public static final int DEFAULT_COLOR_BACKGROUND = 0xFFFFFF;
    public static final int DEFAULT_COLOR_BORDER = 0x808080;
    public static final int DEFAULT_COLOR_TEXT = 0;
    public static final int DEFAULT_COLOR_SELECTED_TEXT = 0xFFFFFF;
    public static final int DEFAULT_COLOR_SELECTED_BACKGROUND = 0xC08888;
    public static final int DEFAULT_COLOR_ARROW = 0xA0A0A0;
    public static final int DEFAULT_COLOR_LIST = 0x8888EE;
    public static final int DEFAULT_COLOR_LIST_TEXT = 0xFFFFFF;
    public int colorBackground = 0xFFFFFF;
    public int colorBorder = 0x808080;
    public int colorText = 0;
    public int colorSelectedText = 0xFFFFFF;
    public int colorSelectedBackground = 0xC08888;
    public int colorArrow = 0xA0A0A0;
    public int colorList = 0x8888EE;
    public int colorListText = 0xFFFFFF;
    protected String leftButtonText = "Ok";
    protected String rightButtonText = "Cancel";
    protected int padding = 3;
    protected Font font;
    protected int fontHeight;
    protected Displayable nextScreen;
    protected int currItem;
    protected int topItem;
    protected int maxItemCount;
    protected int textHeight;
    protected static Display display;
    protected boolean drawBorder = false;
    protected int top = -1;
    protected int bottom = -1;
    protected int left = -1;
    protected int right = -1;
    protected boolean displayList = true;
    protected String[] items;
    protected String[] shortcuts;

    public void prepareShow(Display display, Displayable nextScreen, boolean fullScreenMode) {
        this.prepareShow(display, nextScreen, fullScreenMode, 64, 0, 8);
    }

    public void prepareShow(Display display, Displayable nextScreen, boolean fullScreenMode, int fontFace, int fontStyle, int fontSize) {
        this.prepareShow(display, nextScreen, fullScreenMode, Font.getFont((int)fontFace, (int)fontStyle, (int)fontSize));
    }

    public void prepareShow(Display display, Displayable nextScreen, boolean fullScreenMode, Font font) {
        DisplayList.display = display;
        this.nextScreen = nextScreen;
        this.setFullScreenMode(fullScreenMode);
        this.font = font;
        this.fontHeight = font.getHeight();
        this.textHeight = this.fontHeight + 2 * (this.padding / 2);
        this.top = 0;
        this.left = 0;
        this.bottom = this.getHeight();
        if (this.displayList) {
            this.bottom -= this.textHeight + 2;
        }
        this.maxItemCount = this.bottom / this.textHeight;
        this.topItem = 0;
        this.right = this.getWidth();
    }

    protected abstract void handleKeyRelease(int var1, boolean var2);

    protected void internalHandleKey(int keyCode) {
        boolean handled = false;
        switch (this.getGameAction(keyCode)) {
            case 1: {
                --this.currItem;
                handled = true;
                break;
            }
            case 6: {
                ++this.currItem;
                handled = true;
            }
        }
        if (this.currItem < 0) {
            this.currItem = this.items.length - 1;
        }
        if (this.currItem > this.items.length - 1) {
            this.currItem = 0;
        }
        if (this.currItem < this.topItem) {
            this.topItem = this.currItem;
        }
        if (this.currItem > this.topItem + this.maxItemCount - 1) {
            this.topItem = this.currItem - this.maxItemCount + 1;
        }
        this.repaint();
    }

    public void keyPressed(int keyCode) {
        this.internalHandleKey(keyCode);
    }

    public void keyReleased(int keyCode) {
        boolean handled = false;
        int key = Key.keyCode2Key(keyCode, this);
        switch (key) {
            case 21: {
                break;
            }
            case 20: 
            case 22: {
                handled = true;
                display.setCurrent(this.nextScreen);
            }
        }
        this.handleKeyRelease(key, handled);
    }

    public void keyRepeated(int keyCode) {
        this.internalHandleKey(keyCode);
    }

    public void paint(Graphics g) {
        int currPos;
        int i;
        int border = this.drawBorder ? 1 : 0;
        int height = this.bottom - this.top;
        int width = this.right - this.left;
        g.setColor(this.colorBackground);
        g.fillRect(this.left, this.top, width, height);
        if (this.displayList) {
            g.setColor(this.colorList);
            g.fillRect(0, this.bottom, this.getWidth(), this.getHeight() - this.bottom);
            g.setColor(this.colorBorder);
            g.drawLine(0, this.bottom, this.getWidth(), this.bottom);
            g.setColor(this.colorListText);
            g.drawString(this.leftButtonText, this.padding, this.getHeight(), 36);
            g.drawString(this.rightButtonText, this.getWidth() - this.padding, this.getHeight(), 40);
            g.setClip(this.left, this.top, width, height);
        }
        if (this.drawBorder) {
            g.setColor(this.colorBorder);
            g.drawRect(this.left, this.top, width - 1, height - 1);
        }
        g.setClip(this.left, this.top, width - 1, height - 1);
        for (i = this.topItem; i < this.items.length; ++i) {
            currPos = this.top + (i - this.topItem) * this.textHeight + border;
            if (i != this.currItem) continue;
            g.setColor(this.colorSelectedBackground);
            g.fillRect(this.left + border, currPos, width - 2 * border, this.textHeight + this.padding / 2);
        }
        g.setColor(this.colorArrow);
        if (this.topItem > 0) {
            g.fillTriangle(this.left + width / 2, this.top, this.left + (width - this.textHeight) / 2, this.top + this.textHeight, this.left + (width + this.textHeight) / 2, this.top + this.textHeight);
        }
        if (this.topItem < this.items.length - this.maxItemCount) {
            g.fillTriangle(this.left + width / 2, this.bottom, this.left + (width - this.textHeight) / 2, this.bottom - this.textHeight, this.left + (width + this.textHeight) / 2, this.bottom - this.textHeight);
        }
        g.setFont(this.font);
        for (i = this.topItem; i < this.items.length; ++i) {
            currPos = this.top + (i - this.topItem) * this.textHeight + border + this.padding / 2;
            if (i == this.currItem) {
                g.setColor(this.colorSelectedText);
            } else {
                g.setColor(this.colorText);
            }
            g.drawString(this.items[i], this.left + border + this.padding, currPos, 20);
            if (this.shortcuts == null || this.shortcuts[i] == null) continue;
            g.drawString(this.shortcuts[i], this.right - this.padding, currPos, 24);
        }
    }
}

