/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.Calc4M;
import Calc4M.CalcButton;
import Calc4M.CalcStack;
import Calc4M.CalcTextBox;
import Calc4M.Constants;
import Calc4M.Header;
import Calc4M.Key;
import Calc4M.Menu;
import Calc4M.MenuList;
import Calc4M.Settings;
import Calc4M.StackElement;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import ral.Real;

public class DashBoard
extends Canvas {
    public static final int CALC_MODE_Arithmetic = 1;
    public static final int CALC_MODE_TrigLog = 2;
    public static final int CALC_MODE_Mem = 3;
    public static final int CALC_MODE_Convert = 4;
    public static final int CALC_MODE_Convert2 = 5;
    public static final int CALC_MODE_HexBin = 6;
    public static final int COLOR_BACKGROUND = 15263984;
    private static Display display;
    private static Settings settings;
    private int width;
    private int height;
    private int buttonWidth;
    private int buttonHeight;
    private CalcButton b0;
    private CalcButton b1;
    private CalcButton b2;
    private CalcButton b3;
    private CalcButton b4;
    private CalcButton b5;
    private CalcButton b6;
    private CalcButton b7;
    private CalcButton b8;
    private CalcButton b9;
    private CalcButton bStar;
    private CalcButton bPound;
    private CalcButton bC;
    private CalcButton bBack;
    private CalcButton bUp;
    private CalcButton bDown;
    private CalcButton bLeft;
    private CalcButton bRight;
    private CalcButton bFire;
    private CalcButton bSoftLeft;
    private CalcButton bSoftRight;
    private CalcButton bSend;
    private int currentMode;
    private boolean buttonRepeat;
    private CalcStack calcStack;
    private static Calc4M app;
    private Header header;
    private CalcTextBox calcTextBox;
    private MenuList menuList;

    public DashBoard(Calc4M app, Display display, Settings settings) {
        DashBoard.app = app;
        DashBoard.display = display;
        DashBoard.settings = settings;
        this.calcStack = new CalcStack();
        this.header = new Header();
        this.calcTextBox = new CalcTextBox(this.header.getHeight(), this.getWidth());
        switch (Key.getVendor()) {
            case 2: {
                this.menuList = new MenuList("=", "Menu");
                break;
            }
            case 4: {
                this.menuList = new MenuList("Clear", "Menu");
                break;
            }
            default: {
                this.menuList = new MenuList("Menu", "Clear");
            }
        }
        this.b1 = new CalcButton(1);
        this.b2 = new CalcButton(2);
        this.b3 = new CalcButton(3);
        this.b4 = new CalcButton(4);
        this.b5 = new CalcButton(5);
        this.b6 = new CalcButton(6);
        this.b7 = new CalcButton(7);
        this.b8 = new CalcButton(8);
        this.b9 = new CalcButton(9);
        this.bStar = new CalcButton(10);
        this.b0 = new CalcButton(0);
        this.bPound = new CalcButton(11);
        this.bC = new CalcButton(12);
        this.bC.setFunctionalities(69, 70);
        this.bBack = new CalcButton(13);
        this.bBack.setFunctionalities(74, 0);
        this.bUp = new CalcButton(15);
        this.bUp.setFunctionalities(73, 0);
        this.bDown = new CalcButton(17);
        this.bDown.setFunctionalities(72, 0);
        this.bLeft = new CalcButton(14);
        this.bLeft.setFunctionalities(118, 0);
        this.bRight = new CalcButton(16);
        this.bRight.setFunctionalities(82, 0);
        this.bFire = new CalcButton(18);
        this.bFire.setFunctionalities(71, 0);
        this.bSoftLeft = new CalcButton(19);
        this.bSoftRight = new CalcButton(20);
        this.bSend = new CalcButton(21);
        this.bSend.setFunctionalities(12, 0);
        this.setFullScreenMode(Settings.getFullScreen());
        this.sizeChanged(0, 0);
        this.setMode(1);
    }

    public void setNumberFormat(byte numberFormat) {
        this.calcTextBox.setNumberFormat(numberFormat);
        this.header.setText(Settings.getDRGString());
        this.calcStack.makeAllFinished();
        this.updateCalcTextBox();
        this.repaint();
    }

    public void updateCalcFont() {
        this.repaint();
    }

    public void clear() {
        if (this.calcStack.isEmpty()) {
            this.setMode(1);
        } else {
            StackElement top = this.calcStack.peek();
            if (top.getCalcType() == 1) {
                top.setValueString(top.getValueString().substring(0, top.getValueString().length() - 1));
                if (top.isEditingNumberEmpty()) {
                    this.calcStack.pop();
                }
            } else {
                this.calcStack.pop();
            }
        }
        this.updateCalcTextBox();
        this.repaint();
    }

    public void setFullScreenMode(boolean fullscreen) {
        if (fullscreen) {
            switch (Key.getVendor()) {
                case 2: {
                    this.bSoftLeft.setFunctionalities(12, 0);
                    this.bSoftRight.setFunctionalities(77, 0);
                    break;
                }
                case 4: {
                    this.bSoftLeft.setFunctionalities(69, 70);
                    this.bSoftRight.setFunctionalities(77, 0);
                    break;
                }
                default: {
                    this.bSoftLeft.setFunctionalities(77, 0);
                    this.bSoftRight.setFunctionalities(69, 70);
                    this.bFire.setFunctionalities(71, 0);
                }
            }
            this.removeCommand(DashBoard.app.commandEquals);
            this.removeCommand(DashBoard.app.commandExit);
            this.removeCommand(DashBoard.app.commandToArith);
            this.removeCommand(DashBoard.app.commandToTrigLog);
            this.removeCommand(DashBoard.app.commandToMem);
            this.removeCommand(DashBoard.app.commandToConvert);
            this.removeCommand(DashBoard.app.commandToHexBin);
            this.removeCommand(DashBoard.app.commandConstants);
            this.removeCommand(DashBoard.app.commandSettings);
            this.removeCommand(DashBoard.app.commandHelp);
            this.removeCommand(DashBoard.app.commandClear);
        } else {
            this.bSoftLeft.setFunctionalities(0, 0);
            this.bSoftRight.setFunctionalities(0, 0);
            if (Key.getVendor() != 3 && Key.getVendor() != 5) {
                this.addCommand(DashBoard.app.commandEquals);
            }
            this.addCommand(DashBoard.app.commandExit);
            this.addCommand(DashBoard.app.commandToArith);
            this.addCommand(DashBoard.app.commandToTrigLog);
            this.addCommand(DashBoard.app.commandToMem);
            this.addCommand(DashBoard.app.commandToConvert);
            this.addCommand(DashBoard.app.commandToHexBin);
            this.addCommand(DashBoard.app.commandConstants);
            this.addCommand(DashBoard.app.commandSettings);
            this.addCommand(DashBoard.app.commandHelp);
            if (Key.getVendor() != 2) {
                this.addCommand(DashBoard.app.commandClear);
            }
        }
        super.setFullScreenMode(fullscreen);
    }

    public void setMode(int mode) {
        this.currentMode = mode;
        this.bRight.setFunctionalities(82, 0);
        if (mode == 1) {
            if (Settings.getUseAlternativeLayout()) {
                this.b1.setFunctionalities(2, 15);
                this.b2.setFunctionalities(3, 18);
                this.b3.setFunctionalities(4, 21);
                this.b4.setFunctionalities(5, 24);
                this.b5.setFunctionalities(6, 14);
                this.b6.setFunctionalities(7, 13);
                this.b7.setFunctionalities(8, 16);
                this.b8.setFunctionalities(9, 17);
                this.b9.setFunctionalities(10, 19);
                this.bStar.setFunctionalities(11, 22);
                this.b0.setFunctionalities(1, 23);
                this.bPound.setFunctionalities(12, 20);
            } else {
                this.b1.setFunctionalities(2, 13);
                this.b2.setFunctionalities(3, 14);
                this.b3.setFunctionalities(4, 15);
                this.b4.setFunctionalities(5, 16);
                this.b5.setFunctionalities(6, 17);
                this.b6.setFunctionalities(7, 18);
                this.b7.setFunctionalities(8, 19);
                this.b8.setFunctionalities(9, 20);
                this.b9.setFunctionalities(10, 21);
                this.bStar.setFunctionalities(11, 22);
                this.b0.setFunctionalities(1, 23);
                this.bPound.setFunctionalities(12, 24);
            }
            this.header.setText(null);
        } else if (mode == 2) {
            this.b1.setFunctionalities(25, 26);
            this.b2.setFunctionalities(27, 28);
            this.b3.setFunctionalities(29, 30);
            this.b4.setFunctionalities(31, 32);
            this.b5.setFunctionalities(33, 34);
            this.b6.setFunctionalities(35, 36);
            this.b7.setFunctionalities(37, 119);
            this.b8.setFunctionalities(38, 0);
            this.b9.setFunctionalities(39, 75);
            this.bStar.setFunctionalities(40, 41);
            this.b0.setFunctionalities(42, 76);
            this.bPound.setFunctionalities(43, 44);
            this.header.setText(Settings.getDRGString());
        } else if (mode == 3) {
            this.b1.setFunctionalities(45, 0);
            this.b2.setFunctionalities(46, 0);
            this.b3.setFunctionalities(47, 48);
            this.b4.setFunctionalities(49, 0);
            this.b5.setFunctionalities(50, 0);
            this.b6.setFunctionalities(51, 52);
            this.b7.setFunctionalities(53, 0);
            this.b8.setFunctionalities(54, 0);
            this.b9.setFunctionalities(55, 56);
            this.bStar.setFunctionalities(57, 0);
            this.b0.setFunctionalities(58, 0);
            this.bPound.setFunctionalities(59, 60);
            this.updateMemoryString();
        } else if (mode == 4) {
            this.b1.setFunctionalities(83, 84);
            this.b2.setFunctionalities(85, 86);
            this.b3.setFunctionalities(87, 88);
            this.b4.setFunctionalities(89, 90);
            this.b5.setFunctionalities(91, 92);
            this.b6.setFunctionalities(93, 94);
            this.b7.setFunctionalities(97, 98);
            this.b8.setFunctionalities(95, 96);
            this.b9.setFunctionalities(99, 100);
            this.bStar.setFunctionalities(101, 102);
            this.b0.setFunctionalities(103, 104);
            this.bPound.setFunctionalities(105, 106);
            this.bRight.setFunctionalities(120, 0);
            this.header.setText("Conversions");
        } else if (mode == 5) {
            this.b0.setFunctionalities(107, 108);
        } else if (mode == 6) {
            this.b1.setFunctionalities(2, 109);
            this.b2.setFunctionalities(3, 110);
            this.b3.setFunctionalities(4, 111);
            this.b4.setFunctionalities(5, 112);
            this.b5.setFunctionalities(6, 113);
            this.b6.setFunctionalities(7, 114);
            this.b7.setFunctionalities(8, 115);
            this.b8.setFunctionalities(9, 116);
            this.b9.setFunctionalities(10, 117);
            this.bStar.setFunctionalities(11, 22);
            this.b0.setFunctionalities(1, 23);
            this.bPound.setFunctionalities(12, 0);
            this.header.setText(null);
        }
        this.repaint();
    }

    public void setMode() {
        this.setMode(this.currentMode);
    }

    public void pushReal(Real value) {
        if (!this.calcStack.isEmpty() && this.calcStack.peek().isValue()) {
            this.calcStack.pop();
        }
        this.calcStack.push(value);
        this.updateCalcTextBox();
    }

    private CalcButton keyCode2Button(int keyCode, boolean repeat) {
        CalcButton b = null;
        switch (Key.keyCode2Key(keyCode, this)) {
            case 1: {
                b = this.b0;
                break;
            }
            case 2: {
                b = this.b1;
                break;
            }
            case 3: {
                b = this.b2;
                break;
            }
            case 4: {
                b = this.b3;
                break;
            }
            case 5: {
                b = this.b4;
                break;
            }
            case 6: {
                b = this.b5;
                break;
            }
            case 7: {
                b = this.b6;
                break;
            }
            case 8: {
                b = this.b7;
                break;
            }
            case 9: {
                b = this.b8;
                break;
            }
            case 10: {
                b = this.b9;
                break;
            }
            case 11: {
                b = this.bStar;
                break;
            }
            case 12: {
                b = this.bPound;
                break;
            }
            case 20: {
                b = this.bBack;
                break;
            }
            case 18: {
                b = this.bC;
                break;
            }
            case 15: {
                b = this.bDown;
                break;
            }
            case 17: {
                b = this.bFire;
                break;
            }
            case 16: {
                b = this.bLeft;
                break;
            }
            case 14: {
                b = this.bRight;
                break;
            }
            case 19: {
                b = this.bSend;
                break;
            }
            case 21: {
                b = this.bSoftLeft;
                break;
            }
            case 22: {
                b = this.bSoftRight;
                break;
            }
            case 13: {
                b = this.bUp;
            }
        }
        if (b != null && (repeat && b.getLongFunctionality() == 0 || !repeat && b.getShortFunctionality() == 0)) {
            b = null;
        }
        return b;
    }

    public int keyCode2Function(int keyCode, boolean repeat) {
        CalcButton currButton = this.keyCode2Button(keyCode, repeat);
        if (currButton == null) {
            return 0;
        }
        return repeat ? currButton.getLongFunctionality() : currButton.getShortFunctionality();
    }

    private void handleFunction(int function) {
        switch (function) {
            case 70: {
                this.calcStack.clear();
                break;
            }
            case 69: {
                this.clear();
                break;
            }
            case 74: {
                if (this.calcStack.isEmpty()) {
                    this.setMode(1);
                    break;
                }
                this.calcStack.pop();
                break;
            }
            case 1: 
            case 2: {
                this.addEditingNumber((char)(48 + (function - 1)));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (Settings.getCalcBase() <= 2) break;
                this.addEditingNumber((char)(48 + (function - 1)));
                break;
            }
            case 10: {
                if (Settings.getCalcBase() <= 8) break;
                this.addEditingNumber((char)(48 + (function - 1)));
                break;
            }
            case 11: {
                this.addEditingNumber('.');
                break;
            }
            case 22: {
                if (this.calcStack.isEmpty() || this.calcStack.peek().getCalcType() != 1) break;
                this.calcStack.peek().addToValueString('e');
                break;
            }
            case 38: {
                this.pushReal(new Real(Real.PI));
                break;
            }
            case 42: {
                this.pushReal(new Real(Real.E));
                break;
            }
            case 37: {
                Settings.nextDRG();
                this.header.setText(Settings.getDRGString());
                break;
            }
            case 119: {
                Settings.nextLocalFSE();
                this.calcTextBox.setNumberFormat(Settings.getLocalNFSE());
                this.header.setText(Settings.getDRGString());
                this.calcStack.makeAllFinished();
                break;
            }
            case 0: {
                break;
            }
            case 23: {
                if (this.calcStack.isEmpty()) {
                    this.calcStack.push("-");
                    break;
                }
                StackElement top = this.calcStack.peek();
                if (top.getCalcType() == 1) {
                    this.addEditingNumber('-');
                    break;
                }
                if (top.getCalcType() != 2) break;
                top.getValue().neg();
                break;
            }
            case 75: {
                this.calcStack.switchOperands();
                break;
            }
            case 76: {
                this.calcStack.evaluatePercent();
                break;
            }
            case 71: {
                this.setMode(1);
                break;
            }
            case 72: {
                this.setMode(2);
                break;
            }
            case 73: {
                this.setMode(3);
                break;
            }
            case 82: {
                this.setMode(4);
                break;
            }
            case 120: {
                this.setMode(5);
                break;
            }
            case 118: {
                this.setMode(6);
                break;
            }
            case 12: {
                this.calcStack.evaluateEqual();
                break;
            }
            case 20: {
                this.calcStack.evaluateRP();
                break;
            }
            case 77: {
                Menu.show(app, display, settings, this, Key.getVendor() != 2 && Key.getVendor() != 4, Settings.getFullScreen());
                break;
            }
            case 83: {
                this.calcStack.topMultiply(Constants.cmPerInch);
                break;
            }
            case 84: {
                this.calcStack.topDivide(Constants.cmPerInch);
                break;
            }
            case 85: {
                this.calcStack.topMultiply(Constants.cmPerFoot);
                break;
            }
            case 86: {
                this.calcStack.topDivide(Constants.cmPerFoot);
                break;
            }
            case 87: {
                if (this.calcStack.isEmpty()) break;
                try {
                    this.calcStack.topMultiply(Constants.mPerMile).div(1000);
                }
                catch (Exception e) {}
                break;
            }
            case 88: {
                if (this.calcStack.isEmpty()) break;
                try {
                    this.calcStack.topDivide(Constants.mPerMile).mul(1000);
                }
                catch (Exception e) {}
                break;
            }
            case 89: {
                if (this.calcStack.isEmpty()) break;
                try {
                    this.calcStack.topMultiply(Constants.mPerMile).div(1000);
                }
                catch (Exception e) {}
                break;
            }
            case 90: {
                if (this.calcStack.isEmpty()) break;
                try {
                    this.calcStack.topDivide(Constants.mPerMile).mul(1000);
                }
                catch (Exception e) {}
                break;
            }
            case 91: {
                this.calcStack.topMultiply(Constants.kmhPerMs);
                break;
            }
            case 92: {
                this.calcStack.topDivide(Constants.kmhPerMs);
                break;
            }
            case 93: {
                this.calcStack.topMultiply(Constants.kmhPerKnot);
                break;
            }
            case 94: {
                this.calcStack.topDivide(Constants.kmhPerKnot);
                break;
            }
            case 95: {
                this.calcStack.topMultiply(Constants.kgPerLb);
                break;
            }
            case 96: {
                this.calcStack.topDivide(Constants.kgPerLb);
                break;
            }
            case 97: {
                this.calcStack.topMultiply(Constants.lPerUSGallon);
                break;
            }
            case 98: {
                this.calcStack.topDivide(Constants.lPerUSGallon);
                break;
            }
            case 99: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.mpgToL100km(this.calcStack.pop().getValue()));
                break;
            }
            case 100: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.L100kmToMpg(this.calcStack.pop().getValue()));
                break;
            }
            case 101: {
                if (this.calcStack.isEmpty()) break;
                try {
                    this.calcStack.topMultiply(Constants.wPerHp).div(1000);
                }
                catch (Exception e) {}
                break;
            }
            case 102: {
                if (this.calcStack.isEmpty()) break;
                try {
                    this.calcStack.topDivide(Constants.wPerHp).mul(1000);
                }
                catch (Exception e) {}
                break;
            }
            case 103: {
                if (this.calcStack.isEmpty()) break;
                try {
                    this.calcStack.topMultiply(Constants.jPerKcal).div(1000);
                }
                catch (Exception e) {}
                break;
            }
            case 104: {
                if (this.calcStack.isEmpty()) break;
                try {
                    this.calcStack.topDivide(Constants.jPerKcal).mul(1000);
                }
                catch (Exception exception) {}
                break;
            }
            case 107: {
                this.calcStack.topMultiply(Constants.mjPerKwh);
                break;
            }
            case 108: {
                this.calcStack.topDivide(Constants.mjPerKwh);
                break;
            }
            case 105: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.fToC(this.calcStack.pop().getValue()));
                break;
            }
            case 106: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.cToF(this.calcStack.pop().getValue()));
                break;
            }
            case 115: {
                this.calcStack.makeAllFinished();
                Settings.setCalcBase(2);
                this.header.setText(null);
                break;
            }
            case 116: {
                this.calcStack.makeAllFinished();
                Settings.setCalcBase(10);
                this.header.setText(null);
                break;
            }
            case 117: {
                this.calcStack.makeAllFinished();
                Settings.setCalcBase(16);
                this.header.setText(null);
                break;
            }
            case 109: {
                if (Settings.getCalcBase() <= 10) break;
                this.addEditingNumber('A');
                break;
            }
            case 110: {
                if (Settings.getCalcBase() <= 11) break;
                this.addEditingNumber('B');
                break;
            }
            case 111: {
                if (Settings.getCalcBase() <= 12) break;
                this.addEditingNumber('C');
                break;
            }
            case 112: {
                if (Settings.getCalcBase() <= 13) break;
                this.addEditingNumber('D');
                break;
            }
            case 113: {
                if (Settings.getCalcBase() <= 14) break;
                this.addEditingNumber('E');
                break;
            }
            case 114: {
                if (Settings.getCalcBase() <= 15) break;
                this.addEditingNumber('F');
                break;
            }
            case 48: {
                Settings.clearMemory(1);
                this.updateMemoryString();
                break;
            }
            case 47: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(1, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 45: {
                this.pushReal(new Real(Settings.getMemory(1)));
                break;
            }
            case 46: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(1, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 52: {
                Settings.clearMemory(2);
                this.updateMemoryString();
                break;
            }
            case 51: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(2, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 49: {
                this.pushReal(new Real(Settings.getMemory(2)));
                break;
            }
            case 50: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(2, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 54: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(3, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 56: {
                Settings.clearMemory(3);
                this.updateMemoryString();
                break;
            }
            case 55: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(3, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 53: {
                this.pushReal(new Real(Settings.getMemory(3)));
                break;
            }
            case 58: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(4, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 60: {
                Settings.clearMemory(4);
                this.updateMemoryString();
                break;
            }
            case 59: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(4, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 57: {
                this.pushReal(new Real(Settings.getMemory(4)));
                break;
            }
            case 62: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(5, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 64: {
                Settings.clearMemory(5);
                this.updateMemoryString();
                break;
            }
            case 63: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(5, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 61: {
                this.pushReal(new Real(Settings.getMemory(5)));
                break;
            }
            case 66: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(6, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 68: {
                Settings.clearMemory(6);
                this.updateMemoryString();
                break;
            }
            case 67: {
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(6, this.calcStack.peek().getValue());
                this.updateMemoryString();
                break;
            }
            case 65: {
                this.pushReal(new Real(Settings.getMemory(6)));
                break;
            }
            default: {
                this.addFunctionToStack(function);
            }
        }
        this.calcStack.evaluate();
        this.updateCalcTextBox();
        if (this.currentMode != 1 && Settings.getAutoReturnToArithmetic() && function != 71 && function != 73 && function != 72 && function != 82 && function != 120 && function != 118 && function != 37 && function != 119 && function != 115 && function != 116 && function != 117) {
            this.setMode(1);
        }
    }

    private void addEditingNumber(char ch) {
        if (!this.calcStack.isEmpty() && this.calcStack.peek().getCalcType() == 1) {
            this.calcStack.peek().addToValueString(ch);
        } else {
            if (!this.calcStack.isEmpty() && this.calcStack.peek().getCalcType() == 2) {
                this.calcStack.pop();
            }
            this.calcStack.push(String.valueOf(ch));
        }
    }

    private void addFunctionToStack(int function) {
        int prio = this.getFunctionPrio(function);
        if (prio == 5) {
            if (this.calcStack.popTillNumber()) {
                StackElement top = this.calcStack.pop();
                this.calcStack.push(this.calculateDirectFunction(top.getValue(), function));
            }
        } else if (prio == 4) {
            if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) {
                this.calcStack.push(3);
            }
        } else if (this.calcStack.popTillNumber()) {
            switch (function) {
                case 18: {
                    this.calcStack.push(5);
                    break;
                }
                case 15: {
                    this.calcStack.push(4);
                    break;
                }
                case 21: {
                    this.calcStack.push(6);
                    break;
                }
                case 24: {
                    this.calcStack.push(7);
                    break;
                }
                case 16: {
                    this.calcStack.push(8);
                }
            }
        }
    }

    private int getFunctionPrio(int function) {
        switch (function) {
            case 15: 
            case 18: {
                return 1;
            }
            case 21: 
            case 24: {
                return 2;
            }
            case 16: {
                return 3;
            }
            case 19: {
                return 4;
            }
            case 13: 
            case 14: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return 5;
            }
        }
        return 0;
    }

    private Real calculateDirectFunction(Real value, int function) {
        switch (function) {
            case 43: {
                value.exp10();
                return value;
            }
            case 28: {
                value.acos();
                return this.fromRadians(value);
            }
            case 34: {
                value.acosh();
                return this.fromRadians(value);
            }
            case 26: {
                value.asin();
                return this.fromRadians(value);
            }
            case 32: {
                value.asinh();
                return this.fromRadians(value);
            }
            case 30: {
                value.atan();
                return this.fromRadians(value);
            }
            case 36: {
                value.atanh();
                return this.fromRadians(value);
            }
            case 27: {
                this.toRadians(value).cos();
                return value;
            }
            case 33: {
                this.toRadians(value).cosh();
                return value;
            }
            case 40: {
                value.exp();
                return value;
            }
            case 39: {
                value.fact();
                return value;
            }
            case 17: {
                Real nv = new Real(1);
                nv.div(value);
                value.assign(nv);
                return value;
            }
            case 41: {
                value.ln();
                return value;
            }
            case 44: {
                value.log10();
                return value;
            }
            case 25: {
                this.toRadians(value).sin();
                return value;
            }
            case 31: {
                this.toRadians(value).sinh();
                return value;
            }
            case 14: {
                value.sqr();
                return value;
            }
            case 13: {
                value.sqrt();
                return value;
            }
            case 29: {
                this.toRadians(value).tan();
                return value;
            }
            case 35: {
                this.toRadians(value).tanh();
                return value;
            }
        }
        return value;
    }

    private Real toRadians(Real val) {
        if (Settings.getDRG() == 1) {
            val.mul(Real.PI);
            val.div(180);
        } else if (Settings.getDRG() == 3) {
            val.mul(Real.PI);
            val.div(200);
        }
        return val;
    }

    private Real fromRadians(Real val) {
        if (Settings.getDRG() == 1) {
            val.mul(180);
            val.div(Real.PI);
        } else if (Settings.getDRG() == 3) {
            val.mul(200);
            val.div(Real.PI);
        }
        return val;
    }

    public void equals() {
        this.handleFunction(12);
        this.repaint();
    }

    private void updateMemoryString() {
        this.header.setText(Settings.getMemoryStringShort());
        this.repaint();
    }

    private void updateCalcTextBox() {
        if (Settings.getDoDisplayStack()) {
            this.calcTextBox.setContent(this.calcStack);
        } else {
            this.calcTextBox.setContent(this.calcStack.peek());
        }
    }

    public void keyPressed(int keyCode) {
        CalcButton currButton = this.keyCode2Button(keyCode, false);
        this.buttonRepeat = false;
        if (currButton != null) {
            currButton.setIsPressed(true);
            this.repaint(currButton.getLeft(), currButton.getTop(), currButton.getWidth(), currButton.getHeight());
            this.serviceRepaints();
        }
    }

    public void keyReleased(int keyCode) {
        CalcButton currButton = this.keyCode2Button(keyCode, false);
        if (currButton != null) {
            currButton.setIsPressed(false);
            if (!this.buttonRepeat) {
                this.handleFunction(this.keyCode2Function(keyCode, false));
            }
            this.repaint();
        }
    }

    public void keyRepeated(int keyCode) {
        CalcButton currButton = this.keyCode2Button(keyCode, true);
        if (currButton != null && !this.buttonRepeat) {
            this.buttonRepeat = true;
            this.handleFunction(this.keyCode2Function(keyCode, true));
            currButton.repeatPressed();
            Settings.markRepeat(display);
            this.repaint();
            this.serviceRepaints();
        }
    }

    public void paint(Graphics g) {
        g.setColor(15263984);
        g.fillRect(0, 0, this.width, this.height);
        this.header.paint(g);
        this.calcTextBox.paint(g);
        if (Settings.getFullScreen()) {
            this.menuList.paint(g);
        }
        this.b1.paint(g);
        this.b2.paint(g);
        this.b3.paint(g);
        this.b4.paint(g);
        this.b5.paint(g);
        this.b6.paint(g);
        this.b7.paint(g);
        this.b8.paint(g);
        this.b9.paint(g);
        this.bStar.paint(g);
        this.b0.paint(g);
        this.bPound.paint(g);
    }

    protected void sizeChanged(int w, int h) {
        Real real = new Real();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.header.updateSize(this.width, this.height);
        int localTop = this.header.getHeight();
        this.calcTextBox.updateSize(localTop, this.width);
        this.menuList.updateSize(this.width, this.height);
        int localHeight = Settings.getFullScreen() ? this.height - localTop - this.menuList.getHeight() : this.height - (localTop += this.calcTextBox.getHeight());
        this.buttonHeight = real.assign(localHeight - 7).div(4).toInteger();
        this.buttonWidth = real.assign(this.width - 4).div(3).toInteger();
        int localLeft = real.assign(this.width - this.buttonWidth * 3).div(2).toInteger();
        this.b1.setPosSize(localLeft, localTop += 2, this.buttonWidth, this.buttonHeight);
        this.b2.setPosSize(localLeft + 1 + this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
        this.b3.setPosSize(localLeft + 2 + 2 * this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
        this.b4.setPosSize(localLeft, localTop += this.buttonHeight + 1, this.buttonWidth, this.buttonHeight);
        this.b5.setPosSize(localLeft + 1 + this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
        this.b6.setPosSize(localLeft + 2 + 2 * this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
        this.b7.setPosSize(localLeft, localTop += this.buttonHeight + 1, this.buttonWidth, this.buttonHeight);
        this.b8.setPosSize(localLeft + 1 + this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
        this.b9.setPosSize(localLeft + 2 + 2 * this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
        this.bStar.setPosSize(localLeft, localTop += this.buttonHeight + 1, this.buttonWidth, this.buttonHeight);
        this.b0.setPosSize(localLeft + 1 + this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
        this.bPound.setPosSize(localLeft + 2 + 2 * this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
    }
}

