/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.Settings;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CalcButton {
    private static Font largeFont = Font.getFont((int)0, (int)1, (int)16);
    public static final int COLOR_BUTTON = 0xB0B0FF;
    public static final int COLOR_BUTTON_PRESSED = 0xE0E0FF;
    public static final int COLOR_BUTTON_BORDER = 0x505050;
    public static final int COLOR_BUTTON_TEXT = 0xE0E0FF;
    public static final int COLOR_BUTTON_TEXT_PRESSED = 0xD0D0FF;
    public static final int COLOR_BUTTON_ALT_TEXT = 0;
    public static final int BUTTON_0 = 0;
    public static final int BUTTON_1 = 1;
    public static final int BUTTON_2 = 2;
    public static final int BUTTON_3 = 3;
    public static final int BUTTON_4 = 4;
    public static final int BUTTON_5 = 5;
    public static final int BUTTON_6 = 6;
    public static final int BUTTON_7 = 7;
    public static final int BUTTON_8 = 8;
    public static final int BUTTON_9 = 9;
    public static final int BUTTON_STAR = 10;
    public static final int BUTTON_POUND = 11;
    public static final int BUTTON_C = 12;
    public static final int BUTTON_BACK = 13;
    public static final int BUTTON_LEFT = 14;
    public static final int BUTTON_UP = 15;
    public static final int BUTTON_RIGHT = 16;
    public static final int BUTTON_DOWN = 17;
    public static final int BUTTON_FIRE = 18;
    public static final int BUTTON_SOFT_LEFT = 19;
    public static final int BUTTON_SOFT_RIGHT = 20;
    public static final int BUTTON_SEND = 21;
    public static final int FUNCTION_none = 0;
    public static final int FUNCTION_0 = 1;
    public static final int FUNCTION_1 = 2;
    public static final int FUNCTION_2 = 3;
    public static final int FUNCTION_3 = 4;
    public static final int FUNCTION_4 = 5;
    public static final int FUNCTION_5 = 6;
    public static final int FUNCTION_6 = 7;
    public static final int FUNCTION_7 = 8;
    public static final int FUNCTION_8 = 9;
    public static final int FUNCTION_9 = 10;
    public static final int FUNCTION_decimal = 11;
    public static final int FUNCTION_equals = 12;
    public static final int FUNCTION_sqrt = 13;
    public static final int FUNCTION_sqr = 14;
    public static final int FUNCTION_plus = 15;
    public static final int FUNCTION_pow = 16;
    public static final int FUNCTION_inv = 17;
    public static final int FUNCTION_minus = 18;
    public static final int FUNCTION_leftbracket = 19;
    public static final int FUNCTION_rightbracket = 20;
    public static final int FUNCTION_times = 21;
    public static final int FUNCTION_exp = 22;
    public static final int FUNCTION_plusminus = 23;
    public static final int FUNCTION_div = 24;
    public static final int FUNCTION_sin = 25;
    public static final int FUNCTION_asin = 26;
    public static final int FUNCTION_cos = 27;
    public static final int FUNCTION_acos = 28;
    public static final int FUNCTION_tan = 29;
    public static final int FUNCTION_atan = 30;
    public static final int FUNCTION_sinh = 31;
    public static final int FUNCTION_asinh = 32;
    public static final int FUNCTION_cosh = 33;
    public static final int FUNCTION_acosh = 34;
    public static final int FUNCTION_tanh = 35;
    public static final int FUNCTION_atanh = 36;
    public static final int FUNCTION_drg = 37;
    public static final int FUNCTION_pi = 38;
    public static final int FUNCTION_fac = 39;
    public static final int FUNCTION_e_pow = 40;
    public static final int FUNCTION_ln = 41;
    public static final int FUNCTION_e = 42;
    public static final int FUNCTION_10_pow = 43;
    public static final int FUNCTION_log = 44;
    public static final int FUNCTION_m1r = 45;
    public static final int FUNCTION_m1s = 46;
    public static final int FUNCTION_m1p = 47;
    public static final int FUNCTION_m1c = 48;
    public static final int FUNCTION_m2r = 49;
    public static final int FUNCTION_m2s = 50;
    public static final int FUNCTION_m2p = 51;
    public static final int FUNCTION_m2c = 52;
    public static final int FUNCTION_m3r = 53;
    public static final int FUNCTION_m3s = 54;
    public static final int FUNCTION_m3p = 55;
    public static final int FUNCTION_m3c = 56;
    public static final int FUNCTION_m4r = 57;
    public static final int FUNCTION_m4s = 58;
    public static final int FUNCTION_m4p = 59;
    public static final int FUNCTION_m4c = 60;
    public static final int FUNCTION_m5r = 61;
    public static final int FUNCTION_m5s = 62;
    public static final int FUNCTION_m5p = 63;
    public static final int FUNCTION_m5c = 64;
    public static final int FUNCTION_m6r = 65;
    public static final int FUNCTION_m6s = 66;
    public static final int FUNCTION_m6p = 67;
    public static final int FUNCTION_m6c = 68;
    public static final int FUNCTION_clear = 69;
    public static final int FUNCTION_allclear = 70;
    public static final int FUNCTION_toarith = 71;
    public static final int FUNCTION_totriglog = 72;
    public static final int FUNCTION_tomem = 73;
    public static final int FUNCTION_pop = 74;
    public static final int FUNCTION_switchxy = 75;
    public static final int FUNCTION_percent = 76;
    public static final int FUNCTION_menu = 77;
    public static final int FUNCTION_menu_next = 78;
    public static final int FUNCTION_menu_prev = 79;
    public static final int FUNCTION_menu_select = 80;
    public static final int FUNCTION_menu_exit = 81;
    public static final int FUNCTION_toconvert = 82;
    public static final int FUNCTION_inch_to_cm = 83;
    public static final int FUNCTION_cm_to_inch = 84;
    public static final int FUNCTION_feet_to_cm = 85;
    public static final int FUNCTION_cm_to_feet = 86;
    public static final int FUNCTION_mile_to_km = 87;
    public static final int FUNCTION_km_to_mile = 88;
    public static final int FUNCTION_mph_to_kmh = 89;
    public static final int FUNCTION_kmh_to_mph = 90;
    public static final int FUNCTION_ms_to_kmh = 91;
    public static final int FUNCTION_kmh_to_ms = 92;
    public static final int FUNCTION_knot_to_kmh = 93;
    public static final int FUNCTION_kmh_to_knot = 94;
    public static final int FUNCTION_lb_to_kg = 95;
    public static final int FUNCTION_kg_to_lb = 96;
    public static final int FUNCTION_usg_to_l = 97;
    public static final int FUNCTION_l_to_usg = 98;
    public static final int FUNCTION_mpg_to_l100km = 99;
    public static final int FUNCTION_l100km_to_mpg = 100;
    public static final int FUNCTION_hp_to_kw = 101;
    public static final int FUNCTION_kw_to_hp = 102;
    public static final int FUNCTION_kcal_to_kj = 103;
    public static final int FUNCTION_kj_to_kcal = 104;
    public static final int FUNCTION_f_to_c = 105;
    public static final int FUNCTION_c_to_f = 106;
    public static final int FUNCTION_kwh_to_mj = 107;
    public static final int FUNCTION_mj_to_kwh = 108;
    public static final int FUNCTION_hexa = 109;
    public static final int FUNCTION_hexb = 110;
    public static final int FUNCTION_hexc = 111;
    public static final int FUNCTION_hexd = 112;
    public static final int FUNCTION_hexe = 113;
    public static final int FUNCTION_hexf = 114;
    public static final int FUNCTION_bin = 115;
    public static final int FUNCTION_dec = 116;
    public static final int FUNCTION_hex = 117;
    public static final int FUNCTION_tohex = 118;
    public static final int FUNCTION_fse = 119;
    public static final int FUNCTION_toconvert2 = 120;
    private char buttonChar;
    private int functionShort;
    private int functionLong;
    private int width;
    private int height;
    private int top;
    private int left;
    private static Font altFont;
    private static int padding;
    private static final String[] buttonValues;
    private static final String[] buttonValuesSafe;
    private boolean isPressed = false;

    public CalcButton(int button) {
        this.buttonChar = button < 10 ? (char)(button + 48) : (button == 10 ? (char)42 : (button == 11 ? (char)35 : (button == 12 ? (char)67 : (char)66)));
        this.left = 0;
        this.top = 0;
        this.width = 0;
        this.height = 0;
    }

    public void setIsPressed(boolean isPressed) {
        this.isPressed = isPressed;
    }

    public boolean getIsPressed() {
        return this.isPressed;
    }

    public void repeatPressed() {
        this.isPressed = false;
    }

    public void setFunctionalities(int shortFunction, int longFunction) {
        this.functionShort = shortFunction;
        this.functionLong = longFunction;
    }

    public String getShortText() {
        if (Settings.getSafeStringsMode()) {
            return buttonValuesSafe[this.functionShort];
        }
        return buttonValues[this.functionShort];
    }

    public String getLongText() {
        if (Settings.getSafeStringsMode()) {
            return buttonValuesSafe[this.functionLong];
        }
        return buttonValues[this.functionLong];
    }

    public int getLongFunctionality() {
        return this.functionLong;
    }

    public int getShortFunctionality() {
        return this.functionShort;
    }

    public void setPosSize(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        padding = height / 10;
        for (byte i = 6; i > 0 && height < (altFont = Settings.getFont(i, 32)).getHeight() * 2 + 2 * padding; i = (byte)(i - 1)) {
        }
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void paint(Graphics g) {
        if (this.isPressed) {
            g.setColor(0xE0E0FF);
        } else {
            g.setColor(0xB0B0FF);
        }
        g.fillRoundRect(this.left, this.top, this.width - 1, this.height - 1, this.width / 2, this.height / 2);
        g.setColor(0x505050);
        g.drawRoundRect(this.left, this.top, this.width - 1, this.height - 1, this.width / 2, this.height / 2);
        g.setFont(largeFont);
        if (this.isPressed) {
            g.setColor(0xD0D0FF);
        } else {
            g.setColor(0xE0E0FF);
        }
        g.drawChar(this.buttonChar, this.left + this.width / 2, this.top + this.height / 2 + largeFont.getHeight() / 2, 33);
        g.setFont(altFont);
        g.setColor(0);
        if (this.functionShort != 0) {
            g.drawString(this.getShortText(), this.left + padding, this.top + padding, 20);
        }
        if (this.functionLong != 0) {
            g.drawString(this.getLongText(), this.left + this.width - padding - 1, this.top + this.height - padding, 40);
        }
    }

    static {
        buttonValues = new String[]{null, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "=", "\u221ax", "x\u00b2", "+", "x^y", "1/x", "-", "(", ")", "*", "exp", "\u00b1", "/", "sin", "asin", "cos", "acos", "tan", "atan", "sinh", "asinh", "cosh", "acosh", "tanh", "atanh", "drg", "\u03c0", "n!", "e^x", "ln", "e", "10^x", "log", "m1r", "m1s", "m1+", "m1c", "m2r", "m2s", "m2+", "m2c", "m3r", "m3s", "m3+", "m3c", "m4r", "m4s", "m4+", "m4c", "m5r", "m5s", "m5+", "m5c", "m6r", "m6s", "m6+", "m6c", "C", "AC", "arit", "trig", "mem", "pop", "x\u2194y", "%", "menu", "next", "prev", "ok", "e", "c", "inch\u2198", "\u2196cm", "feet\u2198", "\u2196cm", "mile\u2198", "\u2196km", "mph\u2198", "\u2196km/h", "m/s\u2198", "\u2196km/h", "knot\u2198", "\u2196km/h", "lb\u2198", "\u2196kg", "USGallon", "\u2196l", "mpg\u2198", "l/100km", "hp\u2198", "\u2196kW", "kCal\u2198", "\u2196kJ", "\u00baF\u2198", "\u2196\u00baC", "kWh\u2198", "\u2196MJ", "A", "B", "C", "D", "E", "F", "Bin", "Dec", "Hex", "hex", "eng/sci", "c2"};
        buttonValuesSafe = new String[]{null, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "=", "sqrt(x)", "x^2", "+", "x^y", "1/x", "-", "(", ")", "*", "exp", "-+", "/", "sin", "asin", "cos", "acos", "tan", "atan", "sinh", "asinh", "cosh", "acosh", "tanh", "atanh", "drg", "pi", "n!", "e^x", "ln", "e", "10^x", "log", "m1r", "m1s", "m1+", "m1c", "m2r", "m2s", "m2+", "m2c", "m3r", "m3s", "m3+", "m3c", "m4r", "m4s", "m4+", "m4c", "m5r", "m5s", "m5+", "m5c", "m6r", "m6s", "m6+", "m6c", "C", "AC", "arit", "trig", "mem", "pop", "x<->y", "%", "menu", "next", "prev", "ok", "e", "c", "inch", "cm", "feet", "cm", "mile", "km", "mph", "km/h", "m/s", "km/h", "knot", "km/h", "lb", "kg", "USGallon", "l", "mpg", "l/100km", "hp", "kW", "kCal", "kJ", "\u00baF", "\u00baC", "kWh", "MJ", "A", "B", "C", "D", "E", "F", "Bin", "Dec", "Hex", "hex", "eng/sci", "c2"};
    }
}

