/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Currency;
import JabpLite.JabpLite;
import JabpLite.NameId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class CurrencyStore {
    RecordStore rs;
    JabpLite parent;
    Hashtable ht;

    public CurrencyStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        this.ht = this.parent.currencyHt;
        this.openCurrencyStore();
    }

    void openCurrencyStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)"Currencies", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccy1");
        }
    }

    void closeCurrencyStore() {
        if (this.rs != null) {
            try {
                this.rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " ccy2");
            }
        }
    }

    int getNumCurrencies() {
        if (this.rs != null) {
            try {
                return this.rs.getNumRecords();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " ccy3");
            }
        }
        return 0;
    }

    RecordEnumeration getCurrencies() {
        if (this.rs == null) {
            return null;
        }
        try {
            return this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccy6");
            return null;
        }
    }

    byte[] toByteArray(Currency currency) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(currency.code);
            dataOutputStream.writeUTF(currency.description);
            dataOutputStream.writeInt(currency.rate);
            dataOutputStream.writeInt(currency.oldRate);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    Currency fromByteArray(byte[] byArray) {
        Currency currency = new Currency();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            currency.code = dataInputStream.readUTF();
            currency.description = dataInputStream.readUTF();
            currency.rate = dataInputStream.readInt();
            currency.oldRate = dataInputStream.readInt();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " ccy4a");
        }
        return currency;
    }

    Currency getCurrency(int n) {
        Currency currency = new Currency();
        try {
            byte[] byArray = this.rs.getRecord(n);
            currency = this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccy4 record " + n);
        }
        currency.id = n;
        return currency;
    }

    Currency getCurrencyFromIndex(int n) {
        short s = (short)n;
        int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
        return this.getCurrency(n2);
    }

    Currency getCurrencyFromName(String string) {
        int n = this.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            short s = (short)i;
            String string2 = ((NameId)this.ht.get((Object)new Short((short)s))).name;
            if (!string2.equals(string)) continue;
            int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
            return this.getCurrency(n2);
        }
        Currency currency = new Currency();
        currency.code = string;
        currency.id = this.saveNewCurrency(currency);
        if (this.parent.ccyv != null) {
            ++this.parent.ccyv.numItems;
        }
        return currency;
    }

    void deleteCurrency(Currency currency) {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.deleteRecord(currency.id);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccy5");
        }
    }

    int saveNewCurrency(Currency currency) {
        if (this.rs == null) {
            return 0;
        }
        try {
            currency.id = this.rs.getNextRecordID();
            byte[] byArray = this.toByteArray(currency);
            this.rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccy7");
        }
        this.addIndex(currency);
        return currency.id;
    }

    void saveExistingCurrency(Currency currency) {
        if (this.rs == null) {
            return;
        }
        if (currency.id == 0) {
            System.out.println("Id error in saveExistingCurrency()");
            return;
        }
        try {
            byte[] byArray = this.toByteArray(currency);
            this.rs.setRecord(currency.id, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccy7a");
        }
    }

    int lookUpId(Currency currency) {
        currency.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(currency.code)) continue;
            currency.id = ((NameId)this.ht.get((Object)s)).id;
            break;
        }
        return currency.id;
    }

    int lookUpIndex(Currency currency) {
        int n = this.ht.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(currency.code)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    void deleteIndex(int n) {
        int n2 = this.ht.size();
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i + 1;
            NameId nameId = (NameId)this.ht.get(new Short((short)n3));
            this.ht.put(new Short((short)i), nameId);
        }
        this.ht.remove(new Short((short)(n2 - 1)));
    }

    void addIndex(Currency currency) {
        int n;
        int n2;
        int n3 = n2 = this.ht.size();
        for (n = 0; n < n2; ++n) {
            NameId nameId = (NameId)this.ht.get(new Short((short)n));
            if (currency.code.compareTo(nameId.name) >= 0) continue;
            n3 = n;
            break;
        }
        if (n3 < n2) {
            for (n = n2 - 1; n >= n3; --n) {
                int n4 = n + 1;
                NameId nameId = (NameId)this.ht.get(new Short((short)n));
                this.ht.put(new Short((short)n4), nameId);
            }
        }
        NameId nameId = new NameId(currency.code, currency.id);
        this.ht.put(new Short((short)n3), nameId);
    }

    void compressCurrencies() {
        try {
            byte[] byArray;
            this.parent.currencyHt = new Hashtable();
            this.ht = this.parent.currencyHt;
            RecordStore recordStore = RecordStore.openRecordStore((String)"Temp", (boolean)true);
            RecordEnumeration recordEnumeration = this.getCurrencies();
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            this.closeCurrencyStore();
            RecordStore.deleteRecordStore((String)"Currencies");
            this.openCurrencyStore();
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                Currency currency = this.fromByteArray(byArray);
                currency.id = this.rs.addRecord(byArray, 0, byArray.length);
                this.addIndex(currency);
            }
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"Temp");
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccys8");
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccys9");
            return 0;
        }
    }

    int getRecordSize(int n) {
        try {
            return this.rs.getRecordSize(n);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccys10");
            return 0;
        }
    }
}

