/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.DateId;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class AccountStore {
    RecordStore rs;
    JabpLite parent;
    Hashtable ht;

    public AccountStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        this.ht = this.parent.accountHt;
        this.openAccountStore();
        if (this.getNumAccounts() == 0) {
            this.setUpAccounts();
        }
    }

    void openAccountStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)"\u0423\u0447.\u0417\u0430\u043f\u0438\u0441\u044c", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as1");
        }
    }

    void closeAccountStore() {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as2");
        }
    }

    int getNumAccounts() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as3");
            return 0;
        }
    }

    RecordEnumeration getAccounts() {
        if (this.rs == null) {
            return null;
        }
        try {
            return this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as6");
            return null;
        }
    }

    byte[] toByteArray(Account account) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(account.name);
            dataOutputStream.writeUTF(account.description);
            dataOutputStream.writeUTF(account.currency);
            dataOutputStream.writeUTF(account.type);
            dataOutputStream.writeInt(account.open);
            dataOutputStream.writeInt(account.current);
            dataOutputStream.writeInt(account.today);
            dataOutputStream.writeInt(account.reconciled);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    Account fromByteArray(byte[] byArray) {
        Account account = new Account();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            account.name = dataInputStream.readUTF();
            account.description = dataInputStream.readUTF();
            account.currency = dataInputStream.readUTF();
            account.type = dataInputStream.readUTF();
            account.open = dataInputStream.readInt();
            account.current = dataInputStream.readInt();
            account.today = dataInputStream.readInt();
            account.reconciled = dataInputStream.readInt();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " as4a");
        }
        return account;
    }

    Account getAccount(int n) {
        Account account = new Account();
        try {
            byte[] byArray = this.rs.getRecord(n);
            account = this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as4 record " + n);
        }
        account.id = n;
        return account;
    }

    Account getAccountFromIndex(int n) {
        short s = (short)n;
        int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
        return this.getAccount(n2);
    }

    Account getAccountFromName(String string) {
        int n = this.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            short s = (short)i;
            String string2 = ((NameId)this.ht.get((Object)new Short((short)s))).name;
            if (!string2.equals(string)) continue;
            int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
            return this.getAccount(n2);
        }
        Account account = new Account();
        account.name = string;
        account.currency = this.parent.homeCurrency;
        account.type = "\u0411\u0430\u043d\u043a";
        account.id = this.saveNewAccount(account);
        if (this.parent.av != null) {
            ++this.parent.av.numItems;
        }
        return account;
    }

    void deleteAccount(Account account) {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.deleteRecord(account.id);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as5");
        }
    }

    int saveNewAccount(Account account) {
        if (this.rs == null) {
            return 0;
        }
        try {
            account.id = this.rs.getNextRecordID();
            byte[] byArray = this.toByteArray(account);
            this.rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as7");
        }
        this.addIndex(account);
        this.parent.transactionHt.put(account.name, new Hashtable());
        return account.id;
    }

    void saveExistingAccount(Account account) {
        if (this.rs == null) {
            return;
        }
        if (account.id == 0) {
            System.out.println("Id error in saveExistingAccount()");
            return;
        }
        try {
            byte[] byArray = this.toByteArray(account);
            this.rs.setRecord(account.id, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as7a");
        }
    }

    int lookUpId(Account account) {
        account.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(account.name)) continue;
            account.id = ((NameId)this.ht.get((Object)s)).id;
            break;
        }
        return account.id;
    }

    int lookUpIndex(Account account) {
        int n = this.ht.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(account.name)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    void deleteIndex(int n) {
        int n2 = this.ht.size();
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i + 1;
            NameId nameId = (NameId)this.ht.get(new Short((short)n3));
            this.ht.put(new Short((short)i), nameId);
        }
        this.ht.remove(new Short((short)(n2 - 1)));
    }

    void addIndex(Account account) {
        int n;
        int n2;
        int n3 = n2 = this.ht.size();
        for (n = 0; n < n2; ++n) {
            NameId nameId = (NameId)this.ht.get(new Short((short)n));
            if (account.name.compareTo(nameId.name) >= 0) continue;
            n3 = n;
            break;
        }
        if (n3 < n2) {
            for (n = n2 - 1; n >= n3; --n) {
                int n4 = n + 1;
                NameId nameId = (NameId)this.ht.get(new Short((short)n));
                this.ht.put(new Short((short)n4), nameId);
            }
        }
        NameId nameId = new NameId(account.name, account.id);
        this.ht.put(new Short((short)n3), nameId);
    }

    void updateTodayBalances() {
        Account account = new Account();
        TransactionStore transactionStore = new TransactionStore(this.parent, account);
        long l = Utilities.calcDate(new Date());
        int n = this.getNumAccounts();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                account = this.getAccountFromIndex(i);
                account.today = account.current;
                if (!this.parent.transactionHt.containsKey(account.name)) continue;
                Hashtable hashtable = (Hashtable)this.parent.transactionHt.get(account.name);
                int n2 = hashtable.size();
                if (n2 > 0) {
                    for (int j = 0; j < n2; ++j) {
                        long l2;
                        short s = (short)j;
                        int n3 = ((DateId)hashtable.get((Object)new Short((short)s))).id;
                        Transaction transaction = transactionStore.getTransaction(n3);
                        if (!account.name.equals(transaction.account)) {
                            System.err.println("\u0418\u043c\u044f \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u0438 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432. \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0441\u0435\u0433\u043e\u0434\u043d. \u0411\u0430\u043b\u0430\u043d\u0441\u0430");
                        }
                        if ((l2 = Utilities.calcDate(transaction.date)) <= l) break;
                        account.today -= transaction.amount;
                    }
                }
                this.saveExistingAccount(account);
            }
        }
        transactionStore.closeTransactionStore();
        transactionStore = null;
        account = null;
    }

    void setUpAccounts() {
        Account account = new Account();
        account.currency = this.parent.homeCurrency;
        account.name = "\u0411\u0430\u043d\u043a";
        account.type = "\u0411\u0430\u043d\u043a";
        this.saveNewAccount(account);
        account.name = "\u041a\u0440\u0435\u0434\u0438\u0442\u041a\u0430\u0440\u0442\u0430";
        account.type = "\u041a\u0440\u0435\u0434\u0438\u0442\u041a\u0430\u0440\u0442\u0430";
        this.saveNewAccount(account);
        account.name = "\u0421\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u0438\u044f";
        account.type = "\u0410\u043a\u0442\u0438\u0432";
        this.saveNewAccount(account);
    }

    void compressAccounts() {
        try {
            byte[] byArray;
            this.parent.accountHt = new Hashtable();
            this.ht = this.parent.accountHt;
            RecordStore recordStore = RecordStore.openRecordStore((String)"\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435", (boolean)true);
            RecordEnumeration recordEnumeration = this.getAccounts();
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            this.closeAccountStore();
            RecordStore.deleteRecordStore((String)"\u0423\u0447.\u0417\u0430\u043f\u0438\u0441\u044c");
            this.openAccountStore();
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                Account account = this.fromByteArray(byArray);
                account.id = this.rs.addRecord(byArray, 0, byArray.length);
                this.addIndex(account);
            }
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435");
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as8");
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as9");
            return 0;
        }
    }

    int getSizeAvailable() {
        try {
            return this.rs.getSizeAvailable();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as9a");
            return 0;
        }
    }

    int getRecordSize(int n) {
        try {
            return this.rs.getRecordSize(n);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " as10");
            return 0;
        }
    }
}

