/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;

public class JccEdit
extends Canvas
implements Runnable {
    public static final int MODE_LOWER_CASE = 1;
    public static final int MODE_UPPER_CASE = 2;
    public static final int MODE_NUMBERS = 3;
    static final String sMenuButton = "Menu";
    static final String sClearButton = "<C";
    static final String sReturnButton = "LF";
    static final char[] KEY_NUM1_CHARS = new char[]{'.', '+', '-', '*', '/', '(', ')', ';', '1'};
    static final char[] KEY_NUM2_CHARS = new char[]{'a', 'b', 'c', '2'};
    static final char[] KEY_NUM3_CHARS = new char[]{'d', 'e', 'f', '3'};
    static final char[] KEY_NUM4_CHARS = new char[]{'g', 'h', 'i', '4'};
    static final char[] KEY_NUM5_CHARS = new char[]{'j', 'k', 'l', '5'};
    static final char[] KEY_NUM6_CHARS = new char[]{'m', 'n', 'o', '6'};
    static final char[] KEY_NUM7_CHARS = new char[]{'p', 'q', 'r', 's', '7'};
    static final char[] KEY_NUM8_CHARS = new char[]{'t', 'u', 'v', '8'};
    static final char[] KEY_NUM9_CHARS = new char[]{'w', 'x', 'y', 'z', '9'};
    static final char[] KEY_NUM0_CHARS = new char[]{' ', '0'};
    static final char[] SPECIAL_CHARS = new char[]{';', '(', ')', '{', '}', '[', ']', '!', '-', '_', '+', '=', '|', '\\', '/', '\"', '\'', '@', '#', '$', '%', '^', '&', '*', ':', '<', '>', '?', '.', ','};
    JccEditSettings settings;
    public static final int STATE_SPLASH = 1;
    public static final int STATE_NORMAL = 2;
    public static final int STATE_SELECT_CHAR = 3;
    public static final int STATE_MENU = 4;
    public int currentMode;
    long splashStartTime;
    static final int splashTimeout = 1500;
    int clearKeyCode = Integer.MIN_VALUE;
    Vector vCurText;
    int iCurLine;
    StringBuffer currentText = new StringBuffer();
    int lastPressedKey = Integer.MIN_VALUE;
    int currentKeyStep = 0;
    Font inputFont = null;
    Font linesFont = null;
    Font titleFont = null;
    int inputWidth = 0;
    int inputHeight = 0;
    int inputTranslationY = 10;
    int inputTranslationX = 10;
    int titleHeight;
    int mode = 1;
    String sMode = "abc";
    long selectingCharKeyTime;
    static final int selectingCharKeyTimeout = 900;
    int selectingCharFocus;
    Image imgSelectingCharset;
    int selectingTableWidth;
    int selectingCharW;
    int selectingCharH;
    long lastKeyTimestamp = 0L;
    long maxKeyDelay = 700L;
    int caretIndex = 0;
    int caretLeft = 0;
    boolean caretBlinkOn = true;
    long caretBlinkDelay = 500L;
    long lastCaretBlink = 0L;
    boolean goToNextChar = true;
    String sMsg = "";
    int iNumbersWidth;
    int nLinesMax;
    int selStartLine;
    int selStartX;
    int selStart;
    int selEndLine;
    int selEnd;
    int selEndX;
    boolean bSelecting;
    int offsetLine;
    boolean bScrollMode;
    int scrollStartY;
    boolean bShowLines;
    Display disp;
    TextBox tbText;
    Vector vCommands;
    CommandListener commandListener;
    int menuFocus;
    int menuX;
    int menuY;
    int menuW;
    int menuH;
    int menuBarH;
    int menuBarCenterStrPosition;

    public JccEdit(Display display, Main main) {
        this.disp = display;
        this.settings = new JccEditSettings(main);
        this.inputFont = Font.getFont((int)32, (int)0, (int)8);
        this.linesFont = Font.getFont((int)32, (int)0, (int)8);
        this.titleFont = Font.getFont((int)64, (int)0, (int)8);
        this.iCurLine = 0;
        this.offsetLine = 0;
        this.vCurText = new Vector();
        this.vCurText.addElement("");
        this.vCommands = new Vector();
        if (!this.settings.hasSettings()) {
            this.settings.show(display, this);
        } else {
            this.settings.loadSettings();
            this.reinit();
            display.setCurrent((Displayable)main.constructor);
        }
        new Thread(this).start();
    }

    public void showSettings() {
        this.settings.show(this.disp, this);
    }

    public void showNotify() {
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public void addCommand(Command command) {
        if (!this.vCommands.contains(command)) {
            this.vCommands.addElement(command);
            if (this.menuW - 4 < this.linesFont.stringWidth(command.getLabel())) {
                this.menuW = 4 + this.linesFont.stringWidth(command.getLabel());
                this.menuX = this.getWidth() - this.menuW;
            }
            this.menuH = 4 + this.vCommands.size() * (this.linesFont.getHeight() + 1);
            this.menuY = this.getHeight() - this.menuBarH - this.menuH;
        }
    }

    public void showMenu(boolean bl) {
        this.currentMode = bl ? 4 : 2;
        this.menuFocus = 0;
    }

    public void reinit() {
        int n;
        this.bScrollMode = false;
        this.bShowLines = this.settings.bLineNumbers;
        this.setFullScreenMode(this.settings.bFullscreen);
        this.iNumbersWidth = 1 + this.linesFont.stringWidth("00") + 1;
        this.titleHeight = 1 + this.titleFont.getHeight() + 2;
        this.inputTranslationY = this.titleHeight + 1;
        this.inputHeight = this.getHeight() - this.inputTranslationY;
        this.inputTranslationX = this.bShowLines ? this.iNumbersWidth + 1 : 1;
        this.inputWidth = this.getWidth() - this.inputTranslationX;
        this.nLinesMax = this.inputHeight / (1 + this.inputFont.getHeight());
        this.menuX = this.getWidth();
        this.menuY = this.getHeight();
        this.menuW = 0;
        this.menuH = 0;
        this.menuBarH = this.linesFont.getHeight() + 2;
        this.menuFocus = 0;
        Graphics graphics = this.vCommands.elements();
        while (graphics.hasMoreElements()) {
            Command command = (Command)graphics.nextElement();
            if (this.menuW - 4 < this.linesFont.stringWidth(command.getLabel())) {
                this.menuW = 4 + this.linesFont.stringWidth(command.getLabel());
                this.menuX = this.getWidth() - this.menuW;
            }
            this.menuH = 4 + this.vCommands.size() * (this.linesFont.getHeight() + 1);
            this.menuY = this.getHeight() - this.menuBarH - this.menuH;
        }
        this.menuBarCenterStrPosition = (this.getWidth() - this.linesFont.stringWidth(sReturnButton)) / 2;
        this.currentMode = 1;
        this.splashStartTime = System.currentTimeMillis();
        this.selectingCharKeyTime = -1L;
        this.selectingCharFocus = 0;
        this.imgSelectingCharset = Image.createImage((int)(this.getWidth() - 20), (int)(this.getHeight() - 20));
        graphics = this.imgSelectingCharset.getGraphics();
        graphics.setFont(this.inputFont);
        this.selectingCharW = this.inputFont.charWidth(SPECIAL_CHARS[0]);
        for (n = 1; n < SPECIAL_CHARS.length; ++n) {
            if (this.inputFont.charWidth(SPECIAL_CHARS[n]) <= this.selectingCharW) continue;
            this.selectingCharW = this.inputFont.charWidth(SPECIAL_CHARS[n]);
        }
        this.selectingCharW += 2;
        this.selectingCharH = this.inputFont.getHeight() + 1;
        this.selectingTableWidth = this.imgSelectingCharset.getWidth() / this.selectingCharW;
        graphics.setColor(220, 220, 255);
        graphics.fillRect(0, 0, this.imgSelectingCharset.getWidth(), this.imgSelectingCharset.getHeight());
        graphics.setColor(0);
        for (n = 0; n < SPECIAL_CHARS.length; ++n) {
            int n2 = n / this.selectingTableWidth * this.selectingCharH;
            int n3 = (n - n / this.selectingTableWidth * this.selectingTableWidth) * this.selectingCharW;
            int n4 = this.selectingCharW / 2 - this.inputFont.charWidth(SPECIAL_CHARS[n]);
            graphics.drawChar(SPECIAL_CHARS[n], n3 + 1 + n4, n2 + 1, 20);
        }
    }

    public void setMode(int n) {
        if (n == 1) {
            this.mode = n;
            this.sMode = "abc";
        } else if (n == 2) {
            this.mode = n;
            this.sMode = "ABC";
        } else if (n == 3) {
            this.mode = n;
            this.sMode = "123";
        }
    }

    public String getSelectedString() {
        int n;
        if (this.selStartLine == this.selEndLine && this.selStart == this.selEnd) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.selStartLine;
        int n3 = this.selEndLine;
        int n4 = this.selStart;
        int n5 = this.selEnd;
        if (n2 > n3) {
            n = n2;
            n2 = n3;
            n3 = n;
            n = n4;
            n4 = n5;
            n5 = n;
        } else if (n4 > n5) {
            n = n4;
            n4 = n5;
            n5 = n;
        }
        stringBuffer.append(((String)this.vCurText.elementAt(n2)).substring(n4));
        if (n2 != n3) {
            stringBuffer.append("\n");
        }
        for (n = n2 + 1; n < n3; ++n) {
            stringBuffer.append((String)this.vCurText.elementAt(n));
            stringBuffer.append("\n");
        }
        if (n3 != n2) {
            stringBuffer.append(((String)this.vCurText.elementAt(n3)).substring(0, n5));
        }
        return stringBuffer.toString();
    }

    public void setString(String string) {
        this.vCurText.removeAllElements();
        this.iCurLine = 0;
        this.offsetLine = 0;
        this.caretIndex = 0;
        this.selStartLine = 0;
        this.selStartX = 0;
        this.selStart = 0;
        this.selEndLine = 0;
        this.selEnd = 0;
        this.selEndX = 0;
        this.bSelecting = false;
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                this.vCurText.addElement(string2);
                string2 = "";
                continue;
            }
            if (i == string.length() - 1) {
                string2 = string2 + string.charAt(i);
                this.vCurText.addElement(string2);
                continue;
            }
            string2 = string2 + string.charAt(i);
        }
        if (string.length() == 0) {
            this.vCurText.addElement("");
        }
        this.currentText.delete(0, this.currentText.length());
        this.currentText.append((String)this.vCurText.elementAt(0));
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.vCurText.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public char[] getChars(int n, boolean bl) {
        if (bl) {
            char[] cArray = new char[1];
            switch (n) {
                case 49: {
                    cArray[0] = 49;
                    return cArray;
                }
                case 50: {
                    cArray[0] = 50;
                    return cArray;
                }
                case 51: {
                    cArray[0] = 51;
                    return cArray;
                }
                case 52: {
                    cArray[0] = 52;
                    return cArray;
                }
                case 53: {
                    cArray[0] = 53;
                    return cArray;
                }
                case 54: {
                    cArray[0] = 54;
                    return cArray;
                }
                case 55: {
                    cArray[0] = 55;
                    return cArray;
                }
                case 56: {
                    cArray[0] = 56;
                    return cArray;
                }
                case 57: {
                    cArray[0] = 57;
                    return cArray;
                }
                case 48: {
                    cArray[0] = 48;
                    return cArray;
                }
            }
        } else {
            switch (n) {
                case 49: {
                    return KEY_NUM1_CHARS;
                }
                case 50: {
                    return KEY_NUM2_CHARS;
                }
                case 51: {
                    return KEY_NUM3_CHARS;
                }
                case 52: {
                    return KEY_NUM4_CHARS;
                }
                case 53: {
                    return KEY_NUM5_CHARS;
                }
                case 54: {
                    return KEY_NUM6_CHARS;
                }
                case 55: {
                    return KEY_NUM7_CHARS;
                }
                case 56: {
                    return KEY_NUM8_CHARS;
                }
                case 57: {
                    return KEY_NUM9_CHARS;
                }
                case 48: {
                    return KEY_NUM0_CHARS;
                }
            }
        }
        return null;
    }

    boolean isClearKey(int n) {
        return n == -8;
    }

    void clearChar() {
        if (this.selStartLine != this.selEndLine || this.selStart != this.selEnd) {
            int n;
            if (this.selStartLine > this.selEndLine) {
                n = this.selStartLine;
                this.selStartLine = this.selEndLine;
                this.selEndLine = n;
                n = this.selStart;
                this.selStart = this.selEnd;
                this.selEnd = n;
            } else if (this.selStart > this.selEnd) {
                n = this.selStart;
                this.selStart = this.selEnd;
                this.selEnd = n;
            }
            this.caretIndex = this.selStart;
            this.iCurLine = this.selStartLine;
            this.currentText.delete(0, this.currentText.length());
            String string = ((String)this.vCurText.elementAt(this.selStartLine)).substring(0, this.selStart);
            this.currentText.append(string);
            string = ((String)this.vCurText.elementAt(this.selEndLine)).substring(this.selEnd);
            this.currentText.append(string);
            this.vCurText.setElementAt(this.currentText.toString(), this.selStartLine);
            for (int i = this.selStartLine + 1; i <= this.selEndLine; ++i) {
                this.vCurText.removeElementAt(this.selStartLine + 1);
            }
            this.selStart = this.selEnd = this.caretIndex;
            this.selStartLine = this.selEndLine = this.iCurLine;
            this.selEndX = 0;
            this.selStartX = 0;
            this.updateCaretPosition();
            this.resetBlink();
        } else if (this.currentText.length() > 0 && this.caretIndex > 0) {
            --this.caretIndex;
            this.currentText.deleteCharAt(this.caretIndex);
            this.vCurText.setElementAt(this.currentText.toString(), this.iCurLine);
            this.updateCaretPosition();
            this.resetBlink();
        } else if (this.iCurLine > 0 && this.caretIndex == 0) {
            this.currentText.delete(0, this.currentText.length());
            String string = (String)this.vCurText.elementAt(this.iCurLine - 1);
            this.caretIndex = string.length();
            if (this.caretIndex < 0) {
                this.caretIndex = 0;
            }
            String string2 = string + (String)this.vCurText.elementAt(this.iCurLine);
            this.currentText.append(string2);
            this.vCurText.removeElementAt(this.iCurLine);
            this.vCurText.setElementAt(string2, this.iCurLine - 1);
            --this.iCurLine;
            if (this.iCurLine < this.offsetLine) {
                --this.offsetLine;
            }
            this.updateCaretPosition();
            this.resetBlink();
        }
    }

    void deleteChar() {
        if (this.selStartLine != this.selEndLine || this.selStart != this.selEnd) {
            int n;
            if (this.selStartLine > this.selEndLine) {
                n = this.selStartLine;
                this.selStartLine = this.selEndLine;
                this.selEndLine = n;
            } else if (this.selStart > this.selEnd) {
                n = this.selStart;
                this.selStart = this.selEnd;
                this.selEnd = n;
            }
            this.caretIndex = this.selStart;
            this.iCurLine = this.selStartLine;
            this.currentText.delete(0, this.currentText.length());
            String string = ((String)this.vCurText.elementAt(this.selStartLine)).substring(0, this.selStart);
            this.currentText.append(string);
            string = ((String)this.vCurText.elementAt(this.selEndLine)).substring(this.selEnd);
            this.currentText.append(string);
            this.vCurText.setElementAt(this.currentText.toString(), this.selStartLine);
            for (int i = this.selStartLine + 1; i <= this.selEndLine; ++i) {
                this.vCurText.removeElementAt(this.selStartLine + 1);
            }
            this.selStart = this.selEnd = this.caretIndex;
            this.selStartLine = this.selEndLine = this.iCurLine;
            this.selEndX = 0;
            this.selStartX = 0;
            this.updateCaretPosition();
            this.resetBlink();
        } else if (this.currentText.length() > 0 && this.caretIndex < this.currentText.length() - 1) {
            this.currentText.deleteCharAt(this.caretIndex);
            --this.caretIndex;
            this.vCurText.setElementAt(this.currentText.toString(), this.iCurLine);
            this.updateCaretPosition();
            this.resetBlink();
        }
    }

    void updateCaretPosition() {
        this.caretLeft = this.inputFont.substringWidth((String)this.vCurText.elementAt(this.iCurLine), 0, this.caretIndex);
        if (this.caretLeft + this.inputTranslationX < this.iNumbersWidth + 1) {
            this.inputTranslationX = this.iNumbersWidth + 1 - this.caretLeft;
        } else if (this.caretLeft + this.inputTranslationX > this.inputWidth) {
            this.inputTranslationX = this.inputWidth - this.caretLeft;
        }
    }

    void lineFeed() {
        int n;
        System.out.println("lineFeed");
        if (this.selStartLine != this.selEndLine || this.selStart != this.selEnd) {
            this.clearChar();
            this.bSelecting = false;
        }
        String string = ((String)this.vCurText.elementAt(this.iCurLine)).substring(0, this.caretIndex);
        String string2 = "";
        int n2 = 0;
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
            string2 = string2 + ' ';
        }
        n2 = n;
        string2 = string2 + ((String)this.vCurText.elementAt(this.iCurLine)).substring(this.caretIndex);
        ++this.iCurLine;
        if (this.iCurLine >= this.offsetLine + this.nLinesMax) {
            ++this.offsetLine;
        }
        this.vCurText.setElementAt(string, this.iCurLine - 1);
        this.vCurText.insertElementAt(string2, this.iCurLine);
        this.currentText.delete(0, this.currentText.length());
        this.currentText.append(string2);
        this.caretIndex = n2;
        this.updateCaretPosition();
        this.resetBlink();
        this.goToNextChar = true;
    }

    void moveCaret(int n) {
        this.goToNextChar = true;
        this.currentKeyStep = 0;
        if (n < 0) {
            int n2 = -1;
            while (n < 0) {
                --this.caretIndex;
                ++n;
                if (this.caretIndex != -1) continue;
                if (this.iCurLine > 0) {
                    this.moveUp();
                    this.caretIndex = this.currentText.length();
                    continue;
                }
                this.caretIndex = 0;
                break;
            }
        } else {
            boolean bl = true;
            while (n > 0) {
                ++this.caretIndex;
                --n;
                if (this.caretIndex != this.currentText.length() + 1) continue;
                if (this.iCurLine < this.vCurText.size() - 1) {
                    this.moveDown();
                    this.caretIndex = 0;
                    continue;
                }
                this.caretIndex = this.currentText.length();
                break;
            }
        }
        if (this.bSelecting) {
            if (this.bSelecting) {
                this.selEnd = this.caretIndex;
                this.selEndLine = this.iCurLine;
                this.selEndX = this.inputFont.stringWidth(this.currentText.toString().substring(0, this.caretIndex));
            }
        } else {
            this.selStart = this.selEnd = this.caretIndex;
            this.selEndX = 0;
            this.selStartX = 0;
            this.selStartLine = this.selEndLine = this.iCurLine;
        }
        this.updateCaretPosition();
        this.resetBlink();
        this.goToNextChar = true;
    }

    void moveUp() {
        this.goToNextChar = true;
        this.currentKeyStep = 0;
        if (this.iCurLine > 0) {
            String string;
            --this.iCurLine;
            if (this.iCurLine < this.offsetLine) {
                --this.offsetLine;
            }
            if (this.caretIndex > (string = (String)this.vCurText.elementAt(this.iCurLine)).length()) {
                this.caretIndex = string.length();
            }
            if (this.caretIndex < 0) {
                this.caretIndex = 0;
            }
            if (this.bSelecting) {
                this.selEnd = this.caretIndex;
                this.selEndLine = this.iCurLine;
                this.selEndX = this.inputFont.stringWidth(string.substring(this.caretIndex));
            } else {
                this.selStart = this.selEnd = this.caretIndex;
                this.selEndX = 0;
                this.selStartX = 0;
                this.selStartLine = this.selEndLine = this.iCurLine;
            }
            this.currentText.delete(0, this.currentText.length());
            this.currentText.append(string);
            this.updateCaretPosition();
            this.resetBlink();
            this.goToNextChar = true;
        }
    }

    void moveDown() {
        this.goToNextChar = true;
        this.currentKeyStep = 0;
        if (this.iCurLine < this.vCurText.size() - 1) {
            String string;
            ++this.iCurLine;
            if (this.iCurLine >= this.offsetLine + this.nLinesMax) {
                ++this.offsetLine;
            }
            if (this.caretIndex > (string = (String)this.vCurText.elementAt(this.iCurLine)).length()) {
                this.caretIndex = string.length();
            }
            if (this.caretIndex < 0) {
                this.caretIndex = 0;
            }
            if (this.bSelecting) {
                this.selEnd = this.caretIndex;
                this.selEndLine = this.iCurLine;
                this.selEndX = this.inputFont.stringWidth(string.substring(this.caretIndex));
            } else {
                this.selStart = this.selEnd = this.caretIndex;
                this.selEndX = 0;
                this.selStartX = 0;
                this.selStartLine = this.selEndLine = this.iCurLine;
            }
            this.currentText.delete(0, this.currentText.length());
            this.currentText.append(string);
            this.updateCaretPosition();
            this.resetBlink();
            this.goToNextChar = true;
        }
    }

    public void nextMode() {
        if (this.mode == 1) {
            this.setMode(2);
        } else if (this.mode == 2) {
            this.setMode(3);
        } else if (this.mode == 3) {
            this.setMode(1);
        }
    }

    public void keyPressed(int n) {
        if (this.currentMode == 1) {
            if (n == 48) {
                this.settings.show(this.disp, this);
            }
            return;
        }
        int n2 = this.getGameAction(n);
        if (this.settings.bQwerty) {
            if (this.currentMode == 4) {
                if (n == this.settings.rightSoft) {
                    this.showMenu(false);
                } else if (n2 == 2) {
                    this.showMenu(false);
                } else if (n2 == 5) {
                    if (this.commandListener != null) {
                        this.commandListener.commandAction((Command)this.vCommands.elementAt(this.menuFocus), (Displayable)this);
                    }
                    this.showMenu(false);
                } else if (n2 == 1) {
                    --this.menuFocus;
                    if (this.menuFocus < 0) {
                        this.menuFocus = this.vCommands.size() - 1;
                    }
                } else if (n2 == 6) {
                    ++this.menuFocus;
                    if (this.menuFocus >= this.vCommands.size()) {
                        this.menuFocus = 0;
                    }
                } else if (n2 == 8) {
                    if (this.commandListener != null) {
                        this.commandListener.commandAction((Command)this.vCommands.elementAt(this.menuFocus), (Displayable)this);
                    }
                    this.showMenu(false);
                }
            } else {
                char c = JccEditKeys.getQwertyChar(n);
                int n3 = JccEditKeys.getQwertyControlChar(n);
                if (c != '\uffff') {
                    this.writeChar(c);
                } else if (n3 != -1) {
                    if (n3 == 8) {
                        this.clearChar();
                        this.updateCaretPosition();
                        this.goToNextChar = true;
                    } else if (n3 == 127) {
                        this.deleteChar();
                        this.updateCaretPosition();
                        this.goToNextChar = true;
                    } else if (n3 == -5) {
                        this.lineFeed();
                    } else if (n3 == 9) {
                        this.writeChar('\t');
                    }
                } else if (n == this.settings.leftSoft) {
                    this.clearChar();
                } else if (n == this.settings.rightSoft) {
                    this.showMenu(true);
                } else if (n2 == 2) {
                    this.moveCaret(-1);
                } else if (n2 == 5) {
                    this.moveCaret(1);
                } else if (n2 == 1) {
                    this.moveUp();
                } else if (n2 == 6) {
                    this.moveDown();
                }
            }
        } else if (this.currentMode == 3) {
            if (n == 42) {
                this.currentMode = 2;
                this.selectingCharFocus = 0;
                this.selectingCharKeyTime = -1L;
            } else if (n2 == 2) {
                --this.selectingCharFocus;
                if (this.selectingCharFocus < 0) {
                    this.selectingCharFocus = 0;
                }
            } else if (n2 == 5) {
                ++this.selectingCharFocus;
                if (this.selectingCharFocus >= SPECIAL_CHARS.length) {
                    this.selectingCharFocus = SPECIAL_CHARS.length - 1;
                }
            } else if (n2 == 1) {
                this.selectingCharFocus -= this.selectingTableWidth;
                if (this.selectingCharFocus < 0) {
                    this.selectingCharFocus = 0;
                }
            } else if (n2 == 6) {
                this.selectingCharFocus += this.selectingTableWidth;
                if (this.selectingCharFocus >= SPECIAL_CHARS.length) {
                    this.selectingCharFocus = SPECIAL_CHARS.length - 1;
                }
            } else if (n2 == 8) {
                this.writeChar(SPECIAL_CHARS[this.selectingCharFocus]);
                this.currentMode = 2;
                this.selectingCharFocus = 0;
                this.selectingCharKeyTime = -1L;
            }
        } else if (this.currentMode == 4) {
            if (n == this.settings.rightSoft) {
                this.showMenu(false);
            } else if (n2 == 2) {
                this.showMenu(false);
            } else if (n2 == 5) {
                if (this.commandListener != null) {
                    this.commandListener.commandAction((Command)this.vCommands.elementAt(this.menuFocus), (Displayable)this);
                }
                this.showMenu(false);
            } else if (n2 == 1) {
                --this.menuFocus;
                if (this.menuFocus < 0) {
                    this.menuFocus = this.vCommands.size() - 1;
                }
            } else if (n2 == 6) {
                ++this.menuFocus;
                if (this.menuFocus >= this.vCommands.size()) {
                    this.menuFocus = 0;
                }
            } else if (n2 == 8) {
                if (this.commandListener != null) {
                    this.commandListener.commandAction((Command)this.vCommands.elementAt(this.menuFocus), (Displayable)this);
                }
                this.showMenu(false);
            }
        } else if (this.currentMode == 2) {
            if (n == this.settings.rightSoft) {
                this.showMenu(true);
            } else if (n == this.settings.leftSoft) {
                this.clearChar();
            } else if (this.isClearKey(n)) {
                this.clearChar();
                this.updateCaretPosition();
                this.goToNextChar = true;
            } else if (n >= 48 && n <= 57) {
                this.writeKeyPressed(n);
            } else if (n == 35) {
                this.bSelecting = true;
                this.selStart = this.caretIndex;
                this.selStartLine = this.iCurLine;
                this.selEnd = this.caretIndex;
                this.selEndLine = this.iCurLine;
                this.selEndX = this.selStartX = this.inputFont.stringWidth(this.currentText.toString().substring(0, this.caretIndex));
            } else if (n == 42) {
                this.selectingCharKeyTime = System.currentTimeMillis();
                System.out.println("" + this.selectingCharKeyTime);
            } else if (n2 == 2) {
                this.moveCaret(-1);
            } else if (n2 == 5) {
                this.moveCaret(1);
            } else if (n2 == 1) {
                this.moveUp();
            } else if (n2 == 6) {
                this.moveDown();
            } else if (n2 == 8) {
                this.lineFeed();
            }
        }
    }

    public void keyRepeated(int n) {
        if (n != 42 && n != 35) {
            this.keyPressed(n);
        }
    }

    public void keyReleased(int n) {
        this.sMsg = "";
        if (n == 35) {
            this.bSelecting = false;
        } else if (n == 42 && System.currentTimeMillis() < this.selectingCharKeyTime + 900L) {
            this.currentMode = 2;
            this.nextMode();
            this.selectingCharKeyTime = -1L;
        }
    }

    public void pointerPressed(int n, int n2) {
        int n3;
        if (this.currentMode == 1) {
            this.settings.show(this.disp, this);
            return;
        }
        if (n2 <= this.inputTranslationY) {
            return;
        }
        if (n2 > this.getHeight() - this.menuBarH) {
            if (n < 1 + this.linesFont.stringWidth(sClearButton)) {
                this.clearChar();
                return;
            }
            if (n > this.getWidth() - 1 - this.linesFont.stringWidth(sMenuButton)) {
                if (this.currentMode == 4) {
                    this.showMenu(false);
                } else if (this.currentMode == 2) {
                    this.showMenu(true);
                }
                return;
            }
        }
        if (this.currentMode == 4) {
            int n4;
            if (n < this.menuX || n > this.menuX + this.menuW || n2 < this.menuY || n2 > this.menuY + this.menuH) {
                this.showMenu(false);
                return;
            }
            int n5 = n2 - (this.menuY + 2);
            this.menuFocus = n4 = n5 / (this.linesFont.getHeight() + 1);
            return;
        }
        if (n > this.getWidth() - 5) {
            this.bScrollMode = true;
            this.scrollStartY = n2;
        }
        this.iCurLine = (n3 = n2 / (this.inputFont.getHeight() + 1) - 1 + this.offsetLine) >= this.vCurText.size() ? this.vCurText.size() - 1 : n3;
        String string = (String)this.vCurText.elementAt(this.iCurLine);
        this.caretIndex = 0;
        int n6 = this.inputTranslationX + 1;
        while (this.caretIndex < string.length() && n6 < n) {
            this.selStartX = (n6 += this.inputFont.charWidth(string.charAt(this.caretIndex))) - this.inputTranslationX;
            ++this.caretIndex;
        }
        if (this.caretIndex > string.length()) {
            this.caretIndex = string.length();
        }
        if (this.caretIndex < 0) {
            this.caretIndex = 0;
        }
        this.currentText.delete(0, this.currentText.length());
        this.currentText.append(string);
        this.updateCaretPosition();
        this.resetBlink();
        this.goToNextChar = true;
        this.selStart = this.caretIndex;
        this.selStartLine = this.iCurLine;
        this.selEnd = this.selStart;
        this.selEndLine = this.selStartLine;
        this.selEndX = this.selStartX;
        this.bSelecting = true;
    }

    public void pointerDragged(int n, int n2) {
        if (this.currentMode == 4) {
            int n3;
            if (n < this.menuX || n > this.menuX + this.menuW || n2 < this.menuY || n2 > this.menuY + this.menuH) {
                return;
            }
            int n4 = n2 - (this.menuY + 2);
            this.menuFocus = n3 = n4 / (this.linesFont.getHeight() + 1);
            return;
        }
        if (this.bScrollMode) {
            int n5 = this.getHeight() - this.inputTranslationY - 5;
            int n6 = 15;
            int n7 = this.scrollStartY - n2;
            this.iCurLine = (n2 - this.inputTranslationY - 5) * this.vCurText.size() / (n5 - n6);
            if (this.iCurLine < 0) {
                this.iCurLine = 0;
            }
            if (this.iCurLine >= this.vCurText.size()) {
                this.iCurLine = this.vCurText.size() - 1;
            }
            if (this.iCurLine < this.offsetLine) {
                this.offsetLine = this.iCurLine;
            }
            if (this.iCurLine > this.nLinesMax) {
                this.offsetLine = this.iCurLine - this.nLinesMax + 1;
            }
            return;
        }
        if (n2 <= this.inputTranslationY) {
            this.selEndLine = 0;
            return;
        }
        int n8 = n2 / (this.inputFont.getHeight() + 1) - 1 + this.offsetLine;
        this.iCurLine = n8 >= this.vCurText.size() ? this.vCurText.size() - 1 : n8;
        String string = (String)this.vCurText.elementAt(this.iCurLine);
        this.caretIndex = 0;
        int n9 = this.inputTranslationX + 1;
        while (this.caretIndex < string.length() && n9 < n) {
            n9 += this.inputFont.charWidth(string.charAt(this.caretIndex));
            ++this.caretIndex;
        }
        this.selEndX = n9 - this.inputTranslationX;
        if (this.caretIndex > string.length()) {
            this.caretIndex = string.length();
        }
        if (this.caretIndex < 0) {
            this.caretIndex = 0;
        }
        this.currentText.delete(0, this.currentText.length());
        this.currentText.append(string);
        this.updateCaretPosition();
        this.resetBlink();
        this.goToNextChar = true;
        this.selEnd = this.caretIndex;
        this.selEndLine = this.iCurLine;
    }

    public void pointerReleased(int n, int n2) {
        if (this.bSelecting) {
            this.bSelecting = false;
        }
        if (this.currentMode == 4) {
            if (n < this.menuX || n > this.menuX + this.menuW || n2 < this.menuY || n2 > this.menuY + this.menuH) {
                return;
            }
            int n3 = n2 - (this.menuY + 2);
            int n4 = n3 / (this.linesFont.getHeight() + 1);
            if (this.commandListener != null) {
                this.commandListener.commandAction((Command)this.vCommands.elementAt(n4), (Displayable)this);
            }
            this.showMenu(false);
            return;
        }
    }

    public void insertString(String string) {
        System.out.println("insert " + string);
        if (this.selStartLine != this.selEndLine || this.selStart != this.selEnd) {
            this.clearChar();
            this.bSelecting = false;
        }
        this.goToNextChar = true;
        this.currentKeyStep = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                this.currentText.delete(0, this.currentText.length());
                this.vCurText.insertElementAt("", this.iCurLine + 1);
                ++this.iCurLine;
                this.currentText.append((String)this.vCurText.elementAt(this.iCurLine));
                this.caretIndex = 0;
                continue;
            }
            this.writeChar(string.charAt(i));
        }
        this.currentText.delete(0, this.currentText.length());
        this.currentText.append((String)this.vCurText.elementAt(this.iCurLine));
        this.caretIndex = this.currentText.length();
        this.lastKeyTimestamp = System.currentTimeMillis();
        this.resetBlink();
        this.goToNextChar = true;
    }

    public void writeChar(char c) {
        if (this.selStartLine != this.selEndLine || this.selStart != this.selEnd) {
            this.clearChar();
            this.bSelecting = false;
        }
        this.goToNextChar = true;
        this.currentKeyStep = 0;
        this.currentText.insert(this.caretIndex, c);
        ++this.caretIndex;
        this.vCurText.setElementAt(this.currentText.toString(), this.iCurLine);
        this.updateCaretPosition();
        this.lastKeyTimestamp = System.currentTimeMillis();
        this.resetBlink();
        this.goToNextChar = true;
    }

    public void writeKeyPressed(int n) {
        if (this.selStartLine != this.selEndLine || this.selStart != this.selEnd) {
            this.clearChar();
            this.bSelecting = false;
        }
        if (this.goToNextChar || n != this.lastPressedKey) {
            this.goToNextChar = true;
            this.lastPressedKey = n;
            this.currentKeyStep = 0;
        } else {
            ++this.currentKeyStep;
        }
        char[] cArray = this.getChars(n, this.mode == 3);
        if (cArray != null) {
            if (this.currentKeyStep >= cArray.length) {
                this.currentKeyStep -= cArray.length;
            }
            if (this.mode == 3) {
                this.currentText.insert(this.caretIndex, cArray[0]);
                ++this.caretIndex;
            } else if (this.goToNextChar) {
                String string = "" + cArray[this.currentKeyStep];
                if (this.mode == 2) {
                    string = string.toUpperCase();
                }
                this.currentText.insert(this.caretIndex, string);
                ++this.caretIndex;
            } else {
                String string = "" + cArray[this.currentKeyStep];
                if (this.mode == 2) {
                    string = string.toUpperCase();
                }
                this.currentText.setCharAt(this.caretIndex - 1, string.charAt(0));
            }
            this.vCurText.setElementAt(this.currentText.toString(), this.iCurLine);
            this.updateCaretPosition();
            this.resetBlink();
            this.lastKeyTimestamp = System.currentTimeMillis();
            this.goToNextChar = false;
        }
    }

    public void checkTimestamps() {
        long l = System.currentTimeMillis();
        if (this.currentMode == 1) {
            if (l >= this.splashStartTime + 1500L) {
                this.currentMode = 2;
            }
            return;
        }
        if (this.selectingCharKeyTime != -1L && l >= this.selectingCharKeyTime + 900L) {
            System.out.println("select char");
            this.currentMode = 3;
            this.selectingCharKeyTime = -1L;
        }
        if (this.lastCaretBlink + this.caretBlinkDelay < l) {
            this.caretBlinkOn = !this.caretBlinkOn;
            this.lastCaretBlink = l;
        }
        if (!this.goToNextChar && this.lastKeyTimestamp + this.maxKeyDelay < l) {
            this.goToNextChar = true;
        }
    }

    public void resetBlink() {
        this.lastCaretBlink = System.currentTimeMillis();
        this.caretBlinkOn = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            this.checkTimestamps();
            this.repaint();
            try {
                JccEdit jccEdit = this;
                synchronized (jccEdit) {
                    this.wait(50L);
                    continue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentMode == 1) {
            graphics.setColor(0);
            graphics.drawString("Initializing...", 1, 1, 20);
            graphics.drawString("Press 0 or tap screen for settings", 1, this.getHeight() - 1, 36);
            return;
        }
        graphics.setFont(this.inputFont);
        graphics.setColor(200, 200, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.titleHeight);
        graphics.setColor(50, 50, 100);
        if (!this.settings.bQwerty) {
            graphics.drawString(this.sMode, this.getWidth() - 1, 1, 24);
        }
        graphics.drawLine(0, this.titleHeight, this.getWidth(), this.titleHeight);
        graphics.setColor(0);
        graphics.translate(this.inputTranslationX, 0);
        graphics.setColor(0xFFAAAA);
        int n5 = this.selStartLine - this.offsetLine;
        int n6 = -this.offsetLine + this.selEndLine;
        int n7 = this.selStartX;
        int n8 = this.selEndX;
        if (n5 > n6) {
            n4 = n5;
            n5 = n6;
            n6 = n4;
            n4 = n7;
            n7 = n8;
            n8 = n4;
        }
        if (n5 == n6) {
            if (n7 > n8) {
                n4 = n7;
                n7 = n8;
                n8 = n4;
            }
            n4 = 1 + this.inputTranslationY + (this.iCurLine - this.offsetLine) * (this.inputFont.getHeight() + 1);
            graphics.fillRect(n7, n4, n8 - n7, this.inputFont.getHeight());
        } else {
            n4 = 1 + this.inputTranslationY + (n5 - this.offsetLine) * (this.inputFont.getHeight() + 1);
            graphics.fillRect(n7, n4, this.inputFont.stringWidth((String)this.vCurText.elementAt(n5)) - n7, this.inputFont.getHeight());
            for (n3 = n5 + 1; n3 < n6; ++n3) {
                n4 = 1 + this.inputTranslationY + (n3 - this.offsetLine) * (this.inputFont.getHeight() + 1);
                graphics.fillRect(0, n4, this.inputFont.stringWidth((String)this.vCurText.elementAt(n3)), this.inputFont.getHeight());
            }
            n4 = 1 + this.inputTranslationY + (n6 - this.offsetLine) * (this.inputFont.getHeight() + 1);
            graphics.fillRect(0, n4, n8, this.inputFont.getHeight());
        }
        n4 = 1 + this.inputTranslationY;
        for (n3 = this.offsetLine; n3 < this.offsetLine + this.nLinesMax && n3 < this.vCurText.size(); ++n3) {
            graphics.setColor(0);
            graphics.setFont(this.inputFont);
            graphics.drawString((String)this.vCurText.elementAt(n3), 0, n4, 20);
            n4 += this.inputFont.getHeight() + 1;
        }
        if (this.currentMode != 3 && this.caretBlinkOn && this.goToNextChar) {
            n4 = this.inputTranslationY + (this.iCurLine - this.offsetLine) * (this.inputFont.getHeight() + 1);
            graphics.drawLine(this.caretLeft, n4, this.caretLeft, n4 + this.inputFont.getHeight());
        }
        graphics.translate(-this.inputTranslationX, 0);
        if (this.currentMode == 3) {
            graphics.drawImage(this.imgSelectingCharset, 10, 10, 20);
            n3 = this.selectingCharFocus / this.selectingTableWidth * this.selectingCharH;
            n2 = (this.selectingCharFocus - this.selectingCharFocus / this.selectingTableWidth * this.selectingTableWidth) * this.selectingCharW;
            n = this.selectingCharW / 2 - this.inputFont.charWidth(SPECIAL_CHARS[this.selectingCharFocus]);
            graphics.setColor(220, 200, 200);
            graphics.fillRoundRect(10 + n2, 10 + n3, this.selectingCharW, this.selectingCharH + 1, this.selectingCharW / 2, this.selectingCharH / 2);
            graphics.setColor(0);
            graphics.drawChar(SPECIAL_CHARS[this.selectingCharFocus], 10 + n2 + 1 + n, 10 + n3 + 1, 20);
        }
        if (this.bShowLines) {
            graphics.setColor(0xAAAAFF);
            graphics.fillRect(0, this.inputTranslationY, this.iNumbersWidth, this.inputHeight);
            n4 = 1 + this.inputTranslationY;
            for (n3 = this.offsetLine; n3 < this.offsetLine + this.nLinesMax && n3 < this.vCurText.size(); ++n3) {
                graphics.setColor(160);
                graphics.setFont(this.linesFont);
                graphics.drawString(Integer.toString(n3), 1, n4, 20);
                n4 += this.inputFont.getHeight() + 1;
            }
        }
        n3 = this.getHeight() - this.inputTranslationY - 5;
        n2 = 15;
        n = this.vCurText.size();
        int n9 = this.iCurLine * (n3 - n2) / n;
        graphics.setColor(0x8888FF);
        graphics.fillRect(this.getWidth() - 5, this.inputTranslationY + n9, 4, n2);
        graphics.setFont(this.linesFont);
        graphics.setColor(20, 20, 80);
        graphics.fillRect(0, this.getHeight() - this.menuBarH, this.getWidth(), this.menuBarH);
        graphics.setColor(220, 220, 255);
        graphics.drawString(sMenuButton, this.getWidth() - 1, this.getHeight() - 1, 40);
        if (!this.settings.bQwerty) {
            graphics.drawString(sReturnButton, this.menuBarCenterStrPosition, this.getHeight() - 1, 36);
        }
        graphics.drawString(sClearButton, 1, this.getHeight() - 1, 36);
        if (this.currentMode == 4) {
            graphics.setColor(200, 200, 255);
            graphics.fillRect(this.menuX, this.menuY, this.menuW, this.menuH);
            graphics.setColor(50, 50, 100);
            graphics.drawRect(this.menuX, this.menuY, this.menuW, this.menuH);
            graphics.setColor(80, 80, 120);
            graphics.fillRect(this.menuX + 1, this.menuY + 2 + (this.linesFont.getHeight() + 1) * this.menuFocus, this.menuW - 2, this.linesFont.getHeight());
            n4 = this.menuY + 2;
            graphics.setColor(0);
            Enumeration enumeration = this.vCommands.elements();
            while (enumeration.hasMoreElements()) {
                Command command = (Command)enumeration.nextElement();
                String string = command.getLabel();
                graphics.drawString(string, this.menuX + 2, n4, 20);
                n4 += this.linesFont.getHeight() + 1;
            }
        }
    }
}

