/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public class PaintCanvas
extends GameCanvas
implements Runnable {
    private int x = this.getWidth() / 2;
    private int y = this.getHeight() / 2;
    private int x2 = this.x - 30;
    private int y2 = this.y + 30;
    private int x3 = this.x + 30;
    private int y3 = this.y + 30;
    private int xsrc = 0;
    private int ysrc = 0;
    private int width = 5;
    private int height = 5;
    private int startAngle = 0;
    private int endAngle = 360;
    private int fontSize = 0;
    private int transform = 0;
    protected int bgr = 255;
    protected int bgg = 255;
    protected int bgb = 255;
    protected int fgr = 0;
    protected int fgg = 0;
    protected int fgb = 0;
    private boolean up = false;
    private boolean down = false;
    private boolean left = false;
    private boolean right = false;
    private boolean keyA = false;
    private boolean keyB = false;
    private boolean keyC = false;
    private boolean keyD = false;
    protected boolean increaseIn = false;
    protected boolean solid = false;
    private boolean cut = false;
    private boolean isPasted = false;
    private String text = null;
    protected String stringX = "";
    protected String stringY = "";
    protected int state = 1;
    private int tempState = 1;
    protected Vector vector = null;
    protected Shape shape = null;
    private byte[] b = null;
    protected Thread runner = null;
    protected RecordStore saveShape = null;
    protected RecordStore file_names = null;
    private Graphics g = this.getGraphics();

    public PaintCanvas() {
        super(false);
        try {
            this.saveShape = RecordStore.openRecordStore((String)"SavedDrawings", (boolean)true);
            this.file_names = RecordStore.openRecordStore((String)"DrawingNames", (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println("An error occured whilst creating/openning record store");
        }
        this.vector = new Vector();
        this.setFullScreenMode(true);
    }

    public void draw() {
        this.g.setColor(this.bgr, this.bgg, this.bgb);
        this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.vector.size(); ++i) {
            Shape shape = (Shape)this.vector.elementAt(i);
            if (shape.shapeType == 1) {
                shape.drawRectangle(this.g);
            } else if (shape.shapeType == 2) {
                shape.fillRectangle(this.g);
            } else if (shape.shapeType == 3) {
                shape.drawLines(this.g);
            } else if (shape.shapeType == 4) {
                shape.fillLines(this.g);
            } else if (shape.shapeType == 5) {
                shape.drawCircle(this.g);
            } else if (shape.shapeType == 6) {
                shape.fillCircle(this.g);
            } else if (shape.shapeType == 7) {
                shape.writeText(this.g);
            } else if (shape.shapeType == 8) {
                shape.drawTriangles(this.g);
            } else if (shape.shapeType == 9) {
                shape.fillTriangles(this.g);
            } else if (shape.shapeType == 10) {
                shape.copy(this.g);
            } else if (shape.shapeType == 12) {
                shape.freeHand(this.g);
            }
            shape = null;
        }
        if (this.state == 1) {
            if (this.bgr == 0 && this.bgg == 0 && this.bgb == 0) {
                this.g.setColor(255, 255, 255);
            } else {
                this.g.setColor(0, 0, 0);
            }
            this.g.fillRect(this.x, this.y, 2, 2);
        } else if (this.state == 2 && !this.solid) {
            this.shape = null;
            this.shape = new Shape(this.x, this.y, this.width, this.height, this.fgr, this.fgg, this.fgb, null, 0, 0, 0);
            this.shape.drawRectangle(this.g);
        } else if (this.state == 2 && this.solid) {
            this.shape = null;
            this.shape = new Shape(this.x, this.y, this.width, this.height, this.fgr, this.fgg, this.fgb, null, 0, 0, 0);
            this.shape.fillRectangle(this.g);
        } else if (this.state == 3 && !this.solid) {
            this.shape = null;
            this.shape = new Shape(this.x, this.y, this.width, this.height, this.fgr, this.fgg, this.fgb, null, 0, 0, 0);
            this.shape.drawLines(this.g);
        } else if (this.state == 3 && this.solid) {
            this.shape = null;
            this.shape = new Shape(this.x, this.y, this.width, this.height, this.fgr, this.fgg, this.fgb, null, 0, 0, 0);
            this.shape.fillLines(this.g);
        } else if (this.state == 4 && !this.solid) {
            this.shape = null;
            this.calcAngle();
            this.shape = new Shape(this.x, this.y, this.width, this.height, this.fgr, this.fgg, this.fgb, null, 0, this.startAngle, this.endAngle);
            this.shape.drawCircle(this.g);
        } else if (this.state == 4 && this.solid) {
            this.shape = null;
            this.calcAngle();
            this.shape = new Shape(this.x, this.y, this.width, this.height, this.fgr, this.fgg, this.fgb, null, 0, this.startAngle, this.endAngle);
            this.shape.fillCircle(this.g);
        } else if (this.state == 5) {
            this.shape = null;
            this.shape = new Shape(this.x, this.y, this.width, this.height, this.fgr, this.fgg, this.fgb, this.text, this.fontSize, 0, 0);
            this.shape.writeText(this.g);
        } else if (this.state == 6 && this.solid) {
            this.triangleSize();
            this.shape = null;
            this.shape = new Shape(this.x, this.y, this.x2, this.y2, this.x3, this.y3, this.fgr, this.fgg, this.fgb);
            this.shape.fillTriangles(this.g);
        } else if (this.state == 6 && !this.solid) {
            this.triangleSize();
            this.shape = null;
            this.shape = new Shape(this.x, this.y, this.x2, this.y2, this.x3, this.y3, this.fgr, this.fgg, this.fgb);
            this.shape.drawTriangles(this.g);
        } else if (this.state == 7) {
            this.g.setColor(0, 0, 0);
            this.g.setStrokeStyle(1);
            this.g.drawRect(this.x, this.y, this.width, this.height);
        } else if (this.state == 8) {
            this.shape = null;
            if (this.isPasted) {
                this.shape = new Shape(this.xsrc, this.ysrc, this.width, this.height, this.x, this.y);
                try {
                    this.shape.copy(this.g);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.state = 1;
                    System.err.println(exception.getMessage());
                }
                this.vector.addElement(this.shape);
                this.isPasted = false;
                this.state = 1;
            } else {
                this.state = 1;
            }
            if (this.cut) {
                this.shape = new Shape(this.xsrc, this.ysrc, this.width, this.height, 255, 255, 255, null, 0, 0, 0);
                this.shape.fillRectangle(this.g);
                this.vector.addElement(this.shape);
                this.cut = false;
            }
        } else if (this.state == 9) {
            this.g.setColor(0, 0, 0);
            this.g.setStrokeStyle(1);
            this.g.drawRect(this.x, this.y, this.width, this.height);
        } else if (this.state == 11) {
            this.shape = null;
            this.addZero(this.x, this.y);
            this.shape = new Shape(this.stringX, this.stringY, this.fgr, this.fgg, this.fgb);
            this.shape.freeHand(this.g);
        }
    }

    public void keyPressed(int n) {
        this.showNotify();
        if (this.state != 0) {
            switch (this.getGameAction(n)) {
                case 1: {
                    this.readKey(1, true);
                    break;
                }
                case 6: {
                    this.readKey(6, true);
                    break;
                }
                case 2: {
                    this.readKey(2, true);
                    break;
                }
                case 5: {
                    this.readKey(5, true);
                    break;
                }
                case 8: {
                    if (this.state == 1) {
                        this.state = this.tempState;
                        break;
                    }
                    if (this.state == 7) {
                        this.xsrc = this.x;
                        this.ysrc = this.y;
                        this.state = 1;
                        this.isPasted = true;
                        break;
                    }
                    if (this.state == 9) {
                        this.xsrc = this.x;
                        this.ysrc = this.y;
                        this.state = 1;
                        this.cut = true;
                        this.isPasted = true;
                        break;
                    }
                    if (this.state == 11) {
                        this.reset();
                        this.stringX = null;
                        this.stringY = null;
                        System.gc();
                        this.stringX = "";
                        this.stringY = "";
                        break;
                    }
                    if (this.state == 1 && this.state == 7 && this.state == 9 && this.state == 11) break;
                    this.reset();
                    break;
                }
                case 9: {
                    this.keyA = true;
                    break;
                }
                case 10: {
                    this.keyB = true;
                    break;
                }
                case 11: {
                    this.keyC = true;
                    break;
                }
                case 12: {
                    this.keyD = true;
                }
            }
        }
    }

    public void keyReleased(int n) {
        this.hideNotify();
        switch (this.getGameAction(n)) {
            case 1: {
                this.readKey(1, false);
                break;
            }
            case 6: {
                this.readKey(6, false);
                break;
            }
            case 2: {
                this.readKey(2, false);
                break;
            }
            case 5: {
                this.readKey(5, false);
                break;
            }
            case 9: {
                this.keyA = false;
                break;
            }
            case 10: {
                this.keyB = false;
                break;
            }
            case 11: {
                this.keyC = false;
                break;
            }
            case 12: {
                this.keyD = false;
            }
        }
    }

    private void readKey(int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 1: {
                    this.up = true;
                    break;
                }
                case 6: {
                    this.down = true;
                    break;
                }
                case 2: {
                    this.left = true;
                    break;
                }
                case 5: {
                    this.right = true;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    this.up = false;
                    break;
                }
                case 6: {
                    this.down = false;
                    break;
                }
                case 2: {
                    this.left = false;
                    break;
                }
                case 5: {
                    this.right = false;
                }
            }
        }
    }

    private void pressed() {
        if (this.state == 1 || this.state == 11) {
            if (this.up) {
                if (this.y > 0) {
                    --this.y;
                }
            } else if (this.down) {
                if (this.y < this.getHeight()) {
                    ++this.y;
                }
            } else if (this.left) {
                if (this.x > 0) {
                    --this.x;
                }
            } else if (this.right && this.x < this.getWidth()) {
                ++this.x;
            }
        } else if (this.state != 1 || this.state != 2 || this.state != 11) {
            if (this.up) {
                if (this.height + this.y > this.y) {
                    --this.height;
                }
            } else if (this.down) {
                ++this.height;
            }
            if (this.left && this.x + this.width > this.x) {
                --this.width;
            }
            if (this.right) {
                ++this.width;
            }
        }
    }

    protected void showNotify() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    protected void hideNotify() {
        this.runner = null;
        System.gc();
    }

    protected void setState(int n) {
        this.state = n;
        this.tempState = n;
    }

    protected void setIncrease(boolean bl) {
        this.increaseIn = bl;
    }

    protected void getVector(Vector vector) {
        this.vector = vector;
    }

    protected boolean setSolid(boolean bl) {
        this.solid = bl;
        return bl;
    }

    protected void getTextFont(String string, int n) {
        this.text = string;
        this.fontSize = n;
    }

    private void reset() {
        if (this.state != 7 || this.state != 9) {
            this.vector.addElement(this.shape);
        }
        this.width = 10;
        this.height = 10;
        this.state = 1;
    }

    private void calcAngle() {
        if (this.keyA) {
            ++this.startAngle;
        } else if (this.keyB) {
            this.endAngle = this.endAngle < 360 ? ++this.endAngle : 0;
        } else if (this.keyC) {
            --this.startAngle;
        } else if (this.keyD) {
            this.endAngle = this.endAngle > 0 ? --this.endAngle : 360;
        }
    }

    private void triangleSize() {
        if (!this.increaseIn) {
            if (this.up) {
                --this.y;
            } else if (this.down) {
                ++this.y2;
                ++this.y3;
            } else if (this.left) {
                --this.x2;
            } else if (this.right) {
                ++this.x3;
            }
        } else {
            if (this.up) {
                --this.y2;
                --this.y3;
            }
            if (this.down) {
                ++this.y;
            } else if (this.left) {
                --this.x3;
            } else if (this.right) {
                ++this.x2;
            }
        }
    }

    private void addZero(int n, int n2) {
        String string = Integer.toString(n).trim();
        String string2 = Integer.toString(n2).trim();
        this.stringX = string.length() == 1 ? this.stringX + "00" + string : (string.length() == 2 ? this.stringX + "0" + string : this.stringX + string);
        this.stringY = string2.length() == 1 ? this.stringY + "00" + string2 : (string2.length() == 2 ? this.stringY + "0" + string2 : this.stringY + string2);
        string = null;
        string2 = null;
    }

    protected void addRecord(int n, int n2, int n3, String string, Vector vector) throws IOException, RecordStoreFullException {
        byte[] byArray = string.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(vector.size());
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        Enumeration enumeration = vector.elements();
        try {
            while (enumeration.hasMoreElements()) {
                Shape shape = (Shape)enumeration.nextElement();
                dataOutputStream.writeUTF(this.shape != null ? shape.toStrings() : "");
            }
            dataOutputStream.close();
            this.file_names.addRecord(byArray, 0, byArray.length);
            this.saveShape.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
        }
        catch (IOException iOException) {
            System.err.println("An error occured whilst writng bytes in paint canvas");
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println("An error occurered whilst adding record");
        }
    }

    public Vector fromByteArray(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readInt();
        this.bgr = dataInputStream.readInt();
        this.bgg = dataInputStream.readInt();
        this.bgb = dataInputStream.readInt();
        Vector<Shape> vector = new Vector<Shape>();
        while (n-- > 0) {
            byte[] byArray2 = dataInputStream.readUTF().getBytes();
            Shape shape = new Shape();
            vector.addElement(shape.fromByteArray(byArray2));
        }
        dataInputStream.close();
        return vector;
    }

    public void deleteRecord(int n) {
        try {
            this.file_names.deleteRecord(n);
            this.saveShape.deleteRecord(n);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            System.err.println("An error occurered whilst deleting record");
        }
    }

    public int compare(String string) throws Exception {
        int n = 0;
        int n2 = 0;
        String[] stringArray = new String[this.file_names.getNumRecords()];
        int[] nArray = new int[this.file_names.getNumRecords()];
        RecordEnumeration recordEnumeration = this.file_names.enumerateRecords(null, null, true);
        while (recordEnumeration.hasNextElement()) {
            stringArray[n2] = new String(recordEnumeration.nextRecord());
            ++n2;
        }
        n2 = 0;
        recordEnumeration.reset();
        while (recordEnumeration.hasNextElement()) {
            nArray[n2] = recordEnumeration.nextRecordId();
            ++n2;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (!stringArray[i].trim().equals(string)) continue;
            n = nArray[i];
        }
        recordEnumeration.reset();
        stringArray = null;
        nArray = null;
        recordEnumeration = null;
        System.gc();
        return n;
    }

    public void run() {
        while (this.runner == Thread.currentThread()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("An error occurred with the canvas thread");
            }
            this.draw();
            this.flushGraphics();
            this.pressed();
        }
    }
}

