/*
 * Decompiled with CFR 0.152.
 */
package com.wingfoot.google;

import com.wingfoot.google.GoogleBean;
import com.wingfoot.google.ResultsElement;
import com.wingfoot.soap.Call;
import com.wingfoot.soap.Envelope;
import com.wingfoot.soap.Fault;
import com.wingfoot.soap.encoding.TypeMappingRegistry;
import com.wingfoot.soap.transport.HTTPTransport;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class Google
extends MIDlet
implements CommandListener {
    private static final String key = "GNtDPzzEzyEiXsi2p4H4hlPAi06PW52U";
    private Form form;
    private Form resultForm;
    private Command submitCommand;
    private Command exitCommand;
    private Command newSearchCommand;
    private String queryString;
    private Display display = Display.getDisplay((MIDlet)this);
    private TextField tf;
    private String wingfootRec = "Powered by Wingfoot SOAP";

    public Google() {
        this.submitCommand = new Command("Submit", 4, 1);
        this.exitCommand = new Command("Exit", 7, 1);
        this.form = new Form("GoogleSearch");
        this.tf = new TextField("Search Term", null, 20, 0);
        this.form.append((Item)this.tf);
        this.form.append(this.wingfootRec + "\n");
        this.form.addCommand(this.submitCommand);
        this.form.addCommand(this.exitCommand);
        this.form.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.form);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getLabel().trim().equals("Submit")) {
            if (this.tf.getString() != null && this.tf.getString().length() > 0) {
                this.makeTransaction(this.tf.getString().trim());
            }
        } else if (command.getLabel().trim().equals("New Search")) {
            this.resetForm(false);
        } else if (command.getLabel().trim().equals("Exit")) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
    }

    public void makeTransaction(String string) {
        TypeMappingRegistry typeMappingRegistry = null;
        try {
            Envelope envelope = new Envelope();
            envelope.setSchema("http://www.w3.org/1999/XMLSchema");
            envelope.setSchemaInstance("http://www.w3.org/1999/XMLSchema-instance");
            Call call = new Call(envelope);
            typeMappingRegistry = new TypeMappingRegistry();
            typeMappingRegistry.mapTypes("urn:GoogleSearch", "GoogleSearchResult", Class.forName("com.wingfoot.google.GoogleBean"), Class.forName("com.wingfoot.soap.encoding.BeanSerializer"), Class.forName("com.wingfoot.soap.encoding.BeanSerializer"));
            typeMappingRegistry.mapTypes("urn:GoogleSearch", "ResultElement", Class.forName("com.wingfoot.google.ResultsElement"), Class.forName("com.wingfoot.soap.encoding.BeanSerializer"), Class.forName("com.wingfoot.soap.encoding.BeanSerializer"));
            typeMappingRegistry.mapTypes("urn:GoogleSearch", "DirectoryCategory", Class.forName("com.wingfoot.google.DirectoryCategory"), Class.forName("com.wingfoot.soap.encoding.BeanSerializer"), Class.forName("com.wingfoot.soap.encoding.BeanSerializer"));
            typeMappingRegistry.mapTypes("http://www.w3.org/1999/XMLSchema", "double", Class.forName("com.wingfoot.google.Double"), Class.forName("com.wingfoot.google.DoubleSerializer"), Class.forName("com.wingfoot.google.DoubleSerializer"));
            call.setMappingRegistry(typeMappingRegistry);
            call.addParameter("key", key);
            call.addParameter("q", string);
            call.addParameter("start", new Integer(0));
            call.addParameter("maxResults", new Integer(3));
            call.addParameter("filter", new Boolean(true));
            call.addParameter("restrict", new String("null"));
            call.addParameter("safeSearch", new Boolean(false));
            call.addParameter("lr", new String("null"));
            call.addParameter("ie", "latin1");
            call.addParameter("oe", "latin1");
            call.setMethodName("doGoogleSearch");
            call.setTargetObjectURI("urn:GoogleSearch");
            HTTPTransport hTTPTransport = new HTTPTransport("http://api.google.com/search/beta2", "urn:GoogleSearch");
            Envelope envelope2 = call.invoke(hTTPTransport);
            this.resultForm = new Form("Google Results");
            if (envelope2 == null) {
                Fault fault = envelope2.getFault();
                this.resultForm.append("An Error has occured: " + fault.getFaultString());
                this.resultForm.addCommand(new Command("New Search", 4, 1));
                this.resultForm.addCommand(this.exitCommand);
                this.resultForm.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.resultForm);
            } else {
                GoogleBean googleBean = (GoogleBean)envelope2.getParameter(0);
                Object[] objectArray = googleBean.getResultsElementArray();
                int n = 0;
                while (n < objectArray.length) {
                    ResultsElement resultsElement = (ResultsElement)objectArray[n];
                    this.resultForm.append(this.stripHTML(resultsElement.getTitle()) + "\n");
                    this.resultForm.append(resultsElement.getUrl() + "\n");
                    this.resultForm.append("------------\n");
                    ++n;
                }
                this.resultForm.addCommand(new Command("New Search", 4, 1));
                this.resultForm.addCommand(this.exitCommand);
                this.resultForm.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.resultForm);
            }
        }
        catch (Exception exception) {
            this.resetForm(true);
        }
    }

    private String stripHTML(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[string.length()];
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (!bl) {
                if (cArray[n] == '<') {
                    bl = true;
                } else {
                    cArray2[n] = cArray[n];
                }
            } else if (bl && cArray[n] == '>') {
                bl = false;
            }
            ++n;
        }
        return String.valueOf(cArray2).trim();
    }

    public void resetForm(boolean bl) {
        this.form = new Form("GoogleSearch");
        if (bl) {
            this.form.append("An error has occured\nPlease try again\n");
        }
        this.tf = new TextField("Search Term", null, 20, 0);
        this.form.append((Item)this.tf);
        this.form.append(this.wingfootRec + "\n");
        this.form.addCommand(new Command("Submit", 4, 1));
        this.form.addCommand(new Command("Exit", 7, 1));
        this.form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.form);
    }
}

