/*
 * Decompiled with CFR 0.152.
 */
package I18N;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class I18NPackage {
    private String resourceFile;
    private DataInputStream reader;
    public InputStream is;
    public StringBuffer key = new StringBuffer();
    public StringBuffer value = new StringBuffer();
    public int status;
    public int retvalue;
    public static final char DELIMITER = '~';
    public static final char ENDLINE = '&';
    public static final char ENDFILE = '$';
    public static final char ENDSTRING = '\n';
    public boolean endFILE = false;

    public I18NPackage(String string) {
        this.status = this.loadResources(string);
        if (this.status < 0) {
            this.retvalue = -1;
        }
        this.retvalue = 0;
    }

    public int loadResources(String string) {
        Class<?> clazz = this.getClass();
        if (string == null) {
            return -1;
        }
        this.is = null;
        this.is = clazz.getResourceAsStream(string);
        if (this.is == null) {
            return -1;
        }
        this.reader = new DataInputStream(this.is);
        return 0;
    }

    public int readLine() {
        if (this.key == null || this.value == null || this.reader == null) {
            return -1;
        }
        try {
            int n = this.readKey(this.reader);
            if (n < 0) {
                this.reader.close();
                return -1;
            }
            n = this.readValue(this.reader);
            if (n < 0) {
                return -1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    private int readKey(DataInputStream dataInputStream) throws IOException {
        this.key.delete(0, this.key.length());
        int n = dataInputStream.read();
        while (n != 126 && n != 36) {
            if (n != 10) {
                this.key.append((char)n);
            }
            n = dataInputStream.read();
        }
        if (n == 126 || n == 36) {
            if (n == 36) {
                this.endFILE = true;
                return -1;
            }
            return 0;
        }
        return 0;
    }

    private int readValue(DataInputStream dataInputStream) throws IOException, UTFDataFormatException {
        this.value.delete(0, this.value.length());
        int n = 0;
        if (this.endFILE) {
            return -1;
        }
        block5: while ((n = dataInputStream.read()) > 0 && n != 38) {
            int n2 = n & 0xFF;
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.value.append((char)n2);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int n3 = this.getByte(dataInputStream);
                    if (n3 == -1) {
                        return -1;
                    }
                    if ((n3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.value.append((char)((n2 & 0x1F) << 6 | n3 & 0x3F));
                    continue block5;
                }
                case 14: {
                    int n3 = this.getByte(dataInputStream);
                    if (n3 == -1) {
                        return -1;
                    }
                    int n4 = this.getByte(dataInputStream);
                    if (n4 == -1) {
                        return -1;
                    }
                    if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.value.append((char)((n2 & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return 0;
    }

    private int getByte(InputStream inputStream) throws IOException, UTFDataFormatException {
        int n = inputStream.read();
        if (n < 0 || n == 36) {
            if (n == 36) {
                this.endFILE = true;
                return -1;
            }
            throw new UTFDataFormatException();
        }
        return n;
    }
}

